/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.web.connector.grizzly;

import java.nio.ByteBuffer;

/**
 * Main <code>Task</code> to handle OP_READ.
 *
 * @author Jeanfrancois Arcand
 */
public interface ReadTask extends Task{
    /**
     * Force this task to always use the same <code>ProcessorTask</code> instance.
     */
    public void attachProcessor(ProcessorTask processorTask);

    
    /**
     * Return the <code>ProcessorTask</code> to the pool.
     */
    public void detachProcessor();

    
    /**
     * Return the underlying <code>ByteBuffer</code> used by this class.
     */
    public ByteBuffer getByteBuffer();

    
    public void initialize(StreamAlgorithm algorithm, 
            boolean useDirectByteBuffer, boolean useByteBufferView);

    
    /**
     * If the attached byteBuffer was already filled, tell the
     * Algorithm to re-use the bytes.
     */
    public void setBytesAvailable(boolean bytesAvailable);

    
    /**
     * Complete the processing.
     */
    public void terminate(boolean keepAlive);
    
    
    /**
     * Set the time in milliseconds this <code>Task</code> is allowed to be idle.
     */
    public void setIdleTime(long time);
    
    
    /**
     * Return the time in milliseconds this <code>Task</code> is allowed to be idle.
     */
    public long getIdleTime();
}
