/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.web.connector.grizzly.algorithms;

import com.sun.enterprise.web.connector.grizzly.Handler;
import com.sun.enterprise.web.connector.grizzly.handlers.NoParsingHandler;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;


/**
 * This algorithm doesn't parse the bytes, delegating the work to the 
 * InternalInputBuffer.
 *
 * @author Jeanfrancois Arcand
 */
public class NoParsingAlgorithm extends StreamAlgorithmBase{

    
    public NoParsingAlgorithm() {
        if (embeddedInGlassFish){
            handler = new NoParsingHandler();
        } else {
            handler = new DummyHandler();
        }            
    }
    
    
    /**
     * Do nothing, as the ByteBufferInputStream will take care of reading the 
     * missing bytes.
     */
    public ByteBuffer preParse(ByteBuffer byteBuffer){ 
        return byteBuffer;
    }
    
    
    /**
     * Do not parse the bytes and automatically flip the <code>ByteBuffer</code>
     */
    public boolean parse(ByteBuffer byteBuffer){
        byteBuffer.flip();
        return true;
    }
    
    
    /**
     * Return the <code>Handler</code> used by this algorithm.
     */
    public Handler getHandler(){
        return handler;
    }
    
    
    /***
     * Recycle this object.
     */
    public void recycle(){
        socketChannel = null;
        if ( handler != null){
            handler.attachChannel(null);
        }
    }    
}
