/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.web.connector.grizzly.comet;

import java.io.IOException;

/**
 * This interface allow Java components part of an HTTP request to be polled
 * by the Grizzly Asynchronous Request Mechanism. Components that implement
 * this interface will be notified when another <code>CometHandler</code> 
 * notify them using <code>CometContext.notify</code>.
 *
 * With Servlet, it is recommended to attach the <code>HTTPServletResponse</code>
 * and use this object to push back bytes to the client.
 *
 * @author Jeanfrancois Arcand
 */
public interface CometHandler<E> {

    /**
     * Attach an intance of E to this class.
     */
    public void attach(E attachment);
    
    
    /**
     * Receive <code>CometEvent</code> notification.
     */
    public void onEvent(CometEvent event) throws IOException;
    
    
    /**
     * Receive <code>CometEvent</code> notification when the underlying 
     * tcp communication is started by the client
     */
    public void onInitialize(CometEvent event) throws IOException;
    
    
    /**
     * Receive <code>CometEvent</code> notification when the underlying 
     * tcp communication is closed by the <code>CometHandler</code>
     */
    public void onTerminate(CometEvent event) throws IOException;    
    
    
    /**
     * Receive <code>CometEvent</code> notification when the underlying 
     * tcp communication is resumed by the Grizzly ARP.
     */
    public void onInterrupt(CometEvent event) throws IOException;
    
}
