/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.web.connector.grizzly.handlers;
import com.sun.enterprise.web.connector.grizzly.FileCacheFactory;
import com.sun.enterprise.web.connector.grizzly.Handler;
import com.sun.enterprise.web.connector.grizzly.FileCache;
import com.sun.enterprise.web.connector.grizzly.SelectorThread;
import com.sun.enterprise.web.connector.grizzly.algorithms.ContentLengthAlgorithm;
import java.io.IOException;
import java.nio.channels.SocketChannel;

import org.apache.coyote.Request;
import org.apache.coyote.Response;
import org.apache.coyote.tomcat5.CoyoteConnector;
import org.apache.coyote.tomcat5.CoyoteRequest;
import org.apache.coyote.tomcat5.CoyoteAdapter;
import org.apache.tomcat.util.http.MimeHeaders;


/**
 * This <code>Handler</code> is invoked after the request line has been parsed. 
 *
 * @author Jeanfrancois Arcand
 */
public class ContentLengthHandler implements Handler<Request> {
    
    
    /**
     * The <code>SocketChannel</code> used to send a static resources.
     */
    private SocketChannel socketChannel;
 
    
    /**
     * The FileCache mechanism used to cache static resources.
     */
    protected FileCache fileCache;    
    
    
    /**
     * The <code>Algorithm</code> associated with this handler
     */
    private ContentLengthAlgorithm algorithm;
    
    
    // ---------------------------------------------------------------------//
    
    
    public ContentLengthHandler(ContentLengthAlgorithm algorithm){
        this.algorithm = algorithm;
    }
    
    
    /**
     * Attach a <code>SocketChannel</code> to this object.
     */
    public void attachChannel(SocketChannel socketChannel){
        this.socketChannel = socketChannel;
        if ( fileCache == null && socketChannel != null){
            fileCache = FileCacheFactory.getFactory(
                    socketChannel.socket().getLocalPort()).getFileCache();
        }        
    }
    
    
    /**
     * Add a request URI to the <code>FileCache</code> or use the cache to
     * send the static resources.
     */
    public int handle(Request request, int handlerCode) throws IOException{
        if ( socketChannel == null || !FileCacheFactory.isEnabled())
            return Handler.CONTINUE;
        
        // If not initialized, dont' continue
        if ( fileCache == null && handlerCode != Handler.RESPONSE_PROCEEDED){
             return Handler.CONTINUE;  
        }
    
        if ( handlerCode == Handler.RESPONSE_PROCEEDED ){            
            CoyoteRequest cr = 
                (CoyoteRequest)request.getNote(CoyoteAdapter.ADAPTER_NOTES);
            
            if ( cr != null && cr.getWrapper() != null){

                String mappedServlet = cr.getWrapper().getName();
                
                if ( !mappedServlet.equals(FileCache.DEFAULT_SERVLET_NAME) ) 
                    return Handler.CONTINUE;
                
                if ( cr.getContext().findConstraints().length == 0 
                    && cr.getContext().findFilterDefs().length == 0 ){
                    
                    if (!fileCache.isEnabled()) return Handler.CONTINUE;
                    
                    String docroot;
                    if ( cr.getContextPath().equals("") ){
                        docroot = cr.getContext().getDocBase();
                    } else {
                        docroot = SelectorThread.getWebAppRootPath();
                    }                
                    String requestURI = cr.getRequestURI();
                    Response response = cr.getCoyoteRequest().getResponse();  
                    MimeHeaders headers = response.getMimeHeaders();
                    boolean xPoweredBy = (
                            (CoyoteConnector)cr.getConnector()).isXpoweredBy();

                    fileCache.add(mappedServlet,docroot,requestURI,headers, 
                            xPoweredBy);
                }
            }       
        } else if ( handlerCode == Handler.REQUEST_BUFFERED ) {
            if ( algorithm.startReq != -1 ){
                if ( fileCache.sendCache(algorithm.ascbuf,
                                         algorithm.startReq, 
                                         algorithm.lengthReq, 
                                         socketChannel, true ) ){
                    return Handler.BREAK; 
                }
            }            
        }     
        return Handler.CONTINUE;
    }   
}
