
/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.web.connector.grizzly.ssl;

import com.sun.enterprise.web.connector.grizzly.ByteBufferInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;

/**
 * This class add support for TLS|SSL to a <code>ByteBufferInputStream</code>.
 *
 * @author Jean-Francois Arcand
 */
public class SSLAsyncStream extends ByteBufferInputStream {

    /**
     * The SSLEngine to use for unwrapping bytes.
     */
    private SSLEngine sslEngine;
    
    
    /**
     * The encrypted <code>ByteBuffer</code>
     */
    private ByteBuffer inputBB;
    
    
    /**
     * Read and decrypt bytes from the underlying SSL connections. All
     * the SSLEngine operations are delegated to class <code>SSLUtils</code>.
     */
    protected int doRead(){   
        byteBuffer.compact();
        
        int initialPosition = byteBuffer.position();
        int byteRead = 0;
        while (byteBuffer.position() == initialPosition){
            byteRead += SSLUtils.doRead(key,inputBB,sslEngine,readTimeout);

            if (byteRead > 0) {
                try{
                    byteBuffer = SSLUtils.unwrapAll(byteBuffer,inputBB,sslEngine);
                } catch (IOException ex){
                    Logger logger = SSLSelectorThread.logger();
                    if ( logger.isLoggable(Level.FINE) )
                        logger.log(Level.FINE,"SSLUtils.unwrapAll",ex);
                    return -1;
                }
            }  else {
                break;
            }   
        }

        byteBuffer.flip();
        return byteRead;
    } 

    
    public SSLEngine getSslEngine() {
        return sslEngine;
    }

    
    public void setSslEngine(SSLEngine sslEngine) {
        this.sslEngine = sslEngine;
    }

    
    public ByteBuffer getInputBB() {
        return inputBB;
    }

    
    public void setInputBB(ByteBuffer inputBB) {
        this.inputBB = inputBB;
    }
}

