/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.web.portunif;

import com.sun.enterprise.web.portunif.util.ProtocolInfo;
import java.io.IOException;

/**
 * Once a TCP protocol has been found by a <code>ProtocolFinder</code>
 *
 * @author Jeanfrancois Arcand
 */
public interface ProtocolHandler{
    
    /**
     * Return an array of TCP protocols supported by this ProtocolHandler.
     */
    public String[] getProtocols();
    
    
    /**
     * Handle the current request by either redirecting the request to a new 
     * port or by delivering the request to the proper endpoint.
     */
    public void handle(ProtocolInfo tupple) 
        throws IOException;

}
