/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the "License").  You may not use this file except
 * in compliance with the License.
 *
 * You can obtain a copy of the license at
 * glassfish/bootstrap/legal/CDDLv1.0.txt or
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * HEADER in each file and include the License file at
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable,
 * add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your
 * own identifying information: Portions Copyright [yyyy]
 * [name of copyright owner]
 *
 * Copyright 2005 Sun Microsystems, Inc. All rights reserved.
 *
 * Portions Copyright Apache Software Foundation.
 */ 

package org.apache.taglibs.standard.examples.taglib;

import java.io.IOException;

import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;
import javax.servlet.jsp.jstl.core.*;

import org.apache.taglibs.standard.examples.beans.Customer;

/**
 * <p>Tag handler for &lt;customerFmt&gt;
 *
 * @author Pierre Delisle
 * @version $Revision: 1.2 $ $Date: 2005/12/08 01:20:39 $
 */
public class CustomerFmtTag extends TagSupport {
    
    //*********************************************************************
    // Instance variables
    
    /** Holds value of property customer. */
    private Customer customer;
    
    /** Holds value of property fmt. */
    private String fmt;
    
    //*********************************************************************
    // Constructors
    
    public CustomerFmtTag() {
        super();
        init();
    }
    
    private void init() {
        customer = null;
        fmt = null;
    }    
    
    //*********************************************************************
    // TagSupport methods
    
    public int doStartTag() throws JspException {
        JspWriter out = pageContext.getOut();
        try {
            if (fmt.equalsIgnoreCase("short")) {
                out.println(customer.getFirstName() + " " +
                customer.getLastName());
            } else if (fmt.equalsIgnoreCase("long")) {
                out.println(customer.getFirstName() + " " +
                customer.getLastName() + " " + customer.getAddress());
            } else {
                out.println("invalid format");
            }
        } catch (IOException ex) {}
        
        return SKIP_BODY;
    }
    
    // Releases any resources we may have (or inherit)
    public void release() {
        super.release();
        init();
    }
    
    //*********************************************************************
    // Accessors
    
    /**
     * Getter for property customer.
     * @return Value of property customer.
     */
    public Customer getCustomer() {
        return customer;
    }
    
    /**
     * Setter for property customer.
     * @param customer New value of property customer.
     */
    public void setCustomer(Customer customer) {
        this.customer = customer;
    }
    
    /**
     * Getter for property fmt.
     * @return Value of property fmt.
     */
    public String getFmt() {
        return fmt;
    }
    
    /**
     * Setter for property fmt.
     * @param fmt New value of property fmt.
     */
    public void setFmt(String fmt) {
        this.fmt = fmt;
    }    
}
