/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
/*
 * CheckConfigPropertyName.java
 *
 * Created on October 2, 2000, 11:11 AM
 */

package com.sun.enterprise.tools.verifier.tests.connector;

import java.util.*;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.tools.verifier.tests.*;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.tools.verifier.Result;

/**
 *
 * @author  Jerome Dochez
 * @version 
 */
public class CheckConfigPropertyName extends ConnectorTest implements ConnectorCheck {

    
    /** <p>
     * Properties names defined in the resource adapter config-propery should
     * be unique per resource adapter
     * </p>
     *
     * @paramm descriptor deployment descriptor for the rar file
     * @return result object containing the result of the individual test
     * performed
     */
    public Result check(ConnectorDescriptor descriptor) {
        
        Result result = getInitializedResult();
	ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();
        Set properties = descriptor.getConfigProperties();
        Iterator iterator = properties.iterator();
        // let's add the propery name
        HashSet<String> hs = new HashSet<String>();
        while (iterator.hasNext()) {
            EnvironmentProperty ep = (EnvironmentProperty) iterator.next();
            if (hs.add(ep.getName())==false) {
                // duplicate name...
                result.addErrorDetails(smh.getLocalString
				       ("tests.componentNameConstructor",
					"For [ {0} ]",
					new Object[] {compName.toString()}));
		result.failed(smh.getLocalString(getClass().getName() + ".failed",
                "Error: More than one propery has a duplicate name [ {0} ] in the deployment descriptors",
		new Object[] {ep.getName()}));                     
                return result;
            }            
        }
        // success
        result.addGoodDetails(smh.getLocalString
			      ("tests.componentNameConstructor",
			       "For [ {0} ]",
			       new Object[] {compName.toString()}));	
	result.passed(smh.getLocalString(getClass().getName() + ".passed",
					 "There are no config properties with a duplicate name"));                     
        return result;
        
    }
}
