/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.beanclass;

import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.tools.verifier.*;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import java.util.logging.Level;

import com.sun.enterprise.tools.verifier.tests.*;

/**
 * Bean class test.
 * Verify that the bean class exist and is loadable.
 */

public class EjbClassExist extends EjbTest implements EjbCheck {

    /**
     * Bean class test.
     * Verify that the bean class exist and is loadable.
     *
     * @param descriptor the Enterprise Java Bean deployment descriptor
     *
     * @return <code>Result</code> the results for this assertion
     */
    public Result check(EjbDescriptor descriptor) {

	Result result = getInitializedResult();
	ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();

	// verify that the bean class exist and is loadable
	try {
        Class.forName(descriptor.getEjbClassName(), false, getVerifierContext().getClassLoader());
	    result.addGoodDetails(smh.getLocalString
				  ("tests.componentNameConstructor",
				   "For [ {0} ]",
				   new Object[] {compName.toString()}));
	    result.passed(smh.getLocalString
			  (getClass().getName() + ".passed",
			   "Bean class [ {0} ] exist and is loadable.",
			   new Object[] {descriptor.getEjbClassName()}));

	} catch (NoClassDefFoundError e) {
//	    e.printStackTrace();
	    logger.log(Level.FINE, "Can't find class " + e.getMessage());
	    result.addErrorDetails(smh.getLocalString
				   ("tests.componentNameConstructor",
				    "For [ {0} ]",
				    new Object[] {compName.toString()}));
	    result.failed(smh.getLocalString
			  (getClass().getName() + ".failed",
			   "Error: Bean class [ {0} ] does not exist or is not loadable.",
			   new Object[] {descriptor.getEjbClassName()}));
	} catch (ClassNotFoundException e) {
	    Verifier.debug(e);
	    result.addErrorDetails(smh.getLocalString
				   ("tests.componentNameConstructor",
				    "For [ {0} ]",
				    new Object[] {compName.toString()}));
	    result.failed(smh.getLocalString
			  (getClass().getName() + ".failed",
			   "Error: Bean class [ {0} ] does not exist or is not loadable.",
			   new Object[] {descriptor.getEjbClassName()}));
	} catch (Exception e) {
//	    e.printStackTrace();
	    result.addErrorDetails(smh.getLocalString
				   ("tests.componentNameConstructor",
				    "For [ {0} ]",
				    new Object[] {compName.toString()}));
	    result.failed(smh.getLocalString
			  (getClass().getName() + ".failed",
			   "Error: Bean class [ {0} ] does not exist or is not loadable.",
			   new Object[] {descriptor.getEjbClassName()}));
	}
	return result;
    }
}
