/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
package com.sun.enterprise.tools.verifier.tests.ejb.ejb30;

import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.deployment.EjbDescriptor;

import javax.ejb.Remote;
import javax.ejb.Local;
import java.util.Set;

/**
 * It is an error if @Local or @Remote is specified both on the bean class and 
 * on the referenced interface and the values differ. (Expert Group discussions)
 * 
 * @author Vikas Awasthi
 */
public class BusinessIntfAnnotationValue extends EjbTest {

    private Result result;
    private ComponentNameConstructor compName;
    private Class<Remote> remoteAnn = Remote.class;
    private Class<Local> localAnn = Local.class;
    
    public Result check(EjbDescriptor descriptor) {
        result = getInitializedResult();
        compName = getVerifierContext().getComponentNameConstructor();

        testInterfaces(descriptor.getLocalBusinessClassNames(), remoteAnn);
        testInterfaces(descriptor.getRemoteBusinessClassNames(), localAnn);
    
        if(result.getStatus() != Result.FAILED) {
            addGoodDetails(result, compName);
            result.passed(smh.getLocalString
                            (getClass().getName() + ".passed",
                            "Valid annotations used in business interface(s)."));
        }
        return result;
    }
    
    private void testInterfaces(Set<String> interfaces, Class annot) {
        // used in failure message
        Class cls = (annot.equals(localAnn))? remoteAnn : localAnn;

        for (String intf : interfaces) {
            try {
                Class intfCls = Class.forName(intf,
                                             false,
                                             getVerifierContext().getClassLoader());
                if(intfCls.getAnnotation(annot)!=null) {
                    addErrorDetails(result, compName);
                    result.failed(smh.getLocalString
                                 (getClass().getName() + ".failed",
                                 "{0} annotation is used in {1} interface [ {2} ].", 
                                 new Object[]{annot.getSimpleName(), 
                                             cls.getSimpleName(), 
                                             intfCls.getName()}));
                }
            } catch (ClassNotFoundException e) {
             //ignore as it will be caught in other tests
            }
        }
    }
}
