/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.verifier.tests.ejb.ejb30;

import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbInterceptor;

import java.util.Set;
/**
 * An interceptor class must have a public no-arg constructor.
 * 
 * @author Vikas Awasthi
 */
public class InterceptorNoArgConstructor extends EjbTest {

    public Result check(EjbDescriptor descriptor) {
        Result result = getInitializedResult();
        ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();
        Set<EjbInterceptor> interceptors = descriptor.getInterceptorClasses();
        
        for (EjbInterceptor interceptor : interceptors) {
            try {
                Class interceptorClass = Class.forName(interceptor.getInterceptorClassName(),
                                                       false,
                                                       getVerifierContext().getClassLoader());
                try {
                    interceptorClass.getConstructor(new Class[]{});
                } catch (NoSuchMethodException e) {
                    result.getFaultLocation().setFaultyClass(interceptorClass);
                    addErrorDetails(result, compName);
                    result.failed(smh.getLocalString
                                    (getClass().getName() + ".failed",
                                    "Interceptor class [ {0} ] does not have a " +
                                    "public constructor with no arguments.",
                                    new Object[] {interceptorClass}));
                }
            } catch (ClassNotFoundException e) {}// will be caught in other tests
        }
        if(result.getStatus()!=Result.FAILED) {
            addGoodDetails(result, compName);
            result.passed(smh.getLocalString
                            (getClass().getName() + ".passed",
                            "Valid Interceptor(s) used."));
        } 

        return result;
    }
}
