/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * CmpEjbNoInvalidCreateMethod.java
 *
 * Created on November 13, 2001, 9:36 AM
 */

package com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp;

import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.lang.reflect.*;
import com.sun.enterprise.deployment.*;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
/**
 * Per Ejb 2.0 spec, $14.1.8 create<METHOD> are not supported by 
 * CMP 1.1. EJBs.
 *
 * @author  Jerome Dochez
 * @version 
 */
public class CmpEjbNoInvalidCreateMethod extends EjbTest implements EjbCheck { 


    /** 
     * Entity beans with CMP 1.1 must not define create<METHOD>
     * 
     * @param descriptor the Enterprise Java Bean deployment descriptor
     *   
     * @return <code>Result</code> the results for this assertion
     */
    public Result check(EjbDescriptor descriptor) {

	Result result = getInitializedResult();
        try {

	if (descriptor instanceof EjbCMPEntityDescriptor) {
	    String persistence =
		((EjbEntityDescriptor)descriptor).getPersistenceType();
	    if (EjbEntityDescriptor.CONTAINER_PERSISTENCE.equals(persistence) &&
                   ((EjbCMPEntityDescriptor)descriptor).getCMPVersion()==EjbCMPEntityDescriptor.CMP_1_1) {

                try {
		    Class c = Class.forName(descriptor.getHomeClassName(), false, getVerifierContext().getClassLoader());
		    Method [] methods = c.getDeclaredMethods();
                    boolean oneFailed = false;
                    for (int i=0;i<methods.length;i++) {
                        Method aMethod = methods[i];
                        if (aMethod.getName().startsWith("create")) {
                            if (!aMethod.getName().endsWith("create")) {
				    result.addErrorDetails(smh.getLocalString
							   (getClass().getName() + ".failed",
							    "CMP 1.1 entity beans are not authorized to define [ {0} ] method",
							    new Object[] {aMethod.getName()}));
                                     oneFailed = true;
                            } 
                        }
                    }
                    if (oneFailed) {
		        result.setStatus(Result.FAILED);
                    } else {
                        result.passed(smh.getLocalString
					(getClass().getName() + ".passed",
                                        "No create<METHOD> defined for this CMP 1.1 entity bean [ {0} ] ",
					 new Object[] {descriptor.getName()}));
                    }
                    return result;
                } catch(ClassNotFoundException cnfe) {
		    result.failed(smh.getLocalString
				  (getClass().getName() + ".failedException",
				   "Error: [ {0} ] class not found.",
				   new Object[] {descriptor.getHomeClassName()}));
                    return result;
                } 
            } 
        }
        } catch(Exception e) {
            e.printStackTrace();
        }
        result.notApplicable(smh.getLocalString
                             (getClass().getName() + ".notApplicable",
                              "[ {0} ] is not a CMP 1.1 Entity Bean.",
                              new Object[] {descriptor.getName()}));
       return result;
    }                        
}
