/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp2;

import java.util.*;
import com.sun.enterprise.deployment.*;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.*;


/**
 * cascade-delete tag is not supported for many-many relationships
 *
 * @author  Sheetal Vartak
 * @version 
 */
public class CascadeDeleteNotSupportedForManyMany extends CmrFieldTest {

    /**
     * run an individual verifier test of a declated cmr field of the class
     *
     * @param entity the descriptor for the entity bean containing the cmp-field    
     * @param info the descriptor for the declared cmr field
     * @param c the class owning the cmp field
     * @parma r the result object to use to put the test results in
     * 
     * @return true if the test passed
     */            
    protected boolean runIndividualCmrTest(Descriptor descriptor, RelationRoleDescriptor role, Class c, Result result) {
	boolean isMany = false;
	boolean isPartnerMany = false;
	boolean cascadeDelete = false;
	ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();

	isMany = role.getIsMany();
	isPartnerMany = (role.getPartner()).getIsMany();
	cascadeDelete = role.getCascadeDelete();
	if(isMany && isPartnerMany && cascadeDelete) {
	    addErrorDetails(result, compName);
	    result.addErrorDetails(smh.getLocalString
		   (getClass().getName() + ".failed",
		    "Error: cascade-delete should not be supported for many-many relationships. Please check Relationship Role [{0}]",
	            new Object[] {role.getName()}));
	    return false;
	} else {
	     result.addGoodDetails(smh.getLocalString
				       ("tests.componentNameConstructor",
					"For [ {0} ]",
					new Object[] {compName.toString()}));
	    result.addGoodDetails(smh.getLocalString
	           (getClass().getName() + ".passed",
		    "cascade-delete is not supported for many-many relationships. Test passed.",
	            new Object[] {}));
	    return true;
	}
    }   
}
