/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.verifier.tests.ejb.entity.ejbql;

import com.sun.jdo.spi.persistence.support.ejb.ejbqlc.EJBQLC;
import com.sun.jdo.spi.persistence.support.ejb.ejbqlc.EJBQLException;

import com.sun.enterprise.deployment.PersistenceDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.QueryDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.reflect.Method;
import java.util.Iterator;
import com.sun.enterprise.tools.verifier.tests.*;


/**
 * This class contains tests for EJB QLs that are shared 
 * by tests for entity beans and for depenent objects.
 *
 * @author	Qingqing Ouyang
 * @version
 */
public class EjbQLChecker {
    
    /**
     * <p>
     * helper property to get to the localized strings
     * </p>
     */
    protected static final LocalStringManagerImpl smh = 
        StringManagerHelper.getLocalStringsManager();
    
    /**
     * Check the syntax and semantics of the targetted
     * queries.
     *
     * @param desc An PersistenceDescriptor object.
     * @param ejbqlDriver An EjbQlDriver created using the
     *        targetted ejb bundle.
     * @param result The test results.
     * @param ownerClassName Name of the class initiated the test.
     * @return whether any error has occurred.
     */
    public static boolean checkSyntax (EjbDescriptor ejbDesc, 
            EJBQLC ejbqlDriver, Result result, String ownerClassName) {
        
        boolean hasError = false;
        String query = null;
        PersistenceDescriptor desc = ((EjbCMPEntityDescriptor)ejbDesc).getPersistenceDescriptor();
        
        for (Iterator it = desc.getQueriedMethods().iterator(); it.hasNext();) {
            MethodDescriptor method = (MethodDescriptor) it.next();
            try {
                QueryDescriptor qDesc = desc.getQueryFor(method);
                query = qDesc.getQuery();
                
                if (qDesc.getIsEjbQl()) {
                    Method m = method.getMethod(ejbDesc);

                    int retypeMapping = mapRetType(qDesc.getReturnTypeMapping());
        
                    boolean finder = false;

                    if ((method.getName()).startsWith("find")) {
                       finder = true;
                       retypeMapping = 2; /*QueryDescriptor.NO_RETURN_TYPE_MAPPING;*/
                    }

                    ejbqlDriver.compile(query, m, retypeMapping, finder, ejbDesc.getName());
                }
            } catch (EJBQLException ex) {
                ex.printStackTrace();
                if (!hasError) {
                    hasError = true;
                }
	
                result.addErrorDetails
                    (smh.getLocalString(ownerClassName + ".parseError",
                            "Error: [ {0} ] has parsing error(s)",
                            new Object[] {query}));
		result.addErrorDetails
		    (smh.getLocalString(ownerClassName + ".SAXParseException",
                            "Exception occured : [{0}]",
                            new Object[] {ex.toString()}));
            }

        }
	if (hasError == false) {
	    result.addGoodDetails
		    (smh.getLocalString(ownerClassName + ".passed",
                            " Syntax and Semantics of the Queries are correct",
			    new Object[] {}));
	}
        return hasError;
    }

 private static int mapRetType(int rettype) {

    switch(rettype) {

    case 0 : return 2;
    case 1 : return 0;
    case 2 : return 1;
    default: return 2;
         
    }

 }

}
