/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.enterprise.tools.verifier.tests.ejb.timer;

import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.deployment.*;
import com.sun.enterprise.tools.verifier.*;
import com.sun.enterprise.tools.verifier.tests.*;


/**
 * Check that the transaction attributes for the ejbTimeout method are one
 * of the following -
 * RequiresNew or NotSupported
 *
 * @version 
 * @author Anisha Malhotra
 */
public class HasValidEjbTimeoutDescriptor extends EjbTest {
    Result result = null;
    ComponentNameConstructor compName = null;
    /**
     * Run a verifier test to check the transaction attributes of the
     * ejbTimeout method. The allowed attributes are -
     * RequiresNew or NotSupported.
     *
     * @param descriptor the Enterprise Java Bean deployment descriptor
     *
     * @return <code>Result</code> the results for this assertion
     */
    public Result check(EjbDescriptor descriptor) {

        result = getInitializedResult();
        compName = getVerifierContext().getComponentNameConstructor();

        if(descriptor.isTimedObject()) {

            if (descriptor.getTransactionType().equals
                    (EjbDescriptor.CONTAINER_TRANSACTION_TYPE)) {
                MethodDescriptor methodDesc = descriptor.getEjbTimeoutMethod();
                ContainerTransaction txAttr =
                        descriptor.getContainerTransactionFor(methodDesc);
                String version = getVerifierContext().getJavaEEVersion();
                if(txAttr != null) {
                    String ta = txAttr.getTransactionAttribute();
                    if ((version.compareTo(SpecVersionMapper.JavaEEVersion_5) >= 0) &&
                            !(ContainerTransaction.REQUIRES_NEW.equals(ta)
                            || ContainerTransaction.NOT_SUPPORTED.equals(ta)
                            || ContainerTransaction.REQUIRED.equals(ta))) {
                        addErrorDetails(result, compName);
                        result.failed(smh.getLocalString
                                (getClass().getName()+".failed1",
                                "Error : Bean [ {0} ] Transaction attribute for timeout method" +
                                "must be Required, RequiresNew or NotSupported",
                                new Object[] {descriptor.getName()}));
                    } else if ((version.compareTo(SpecVersionMapper.JavaEEVersion_5) < 0) &&
                            !(ContainerTransaction.REQUIRES_NEW.equals(ta)
                            || ContainerTransaction.NOT_SUPPORTED.equals(ta))) {
                        addErrorDetails(result, compName);
                        result.failed(smh.getLocalString
                                (getClass().getName()+".failed2",
                                "Error : Bean [ {0} ] Transaction attribute for ejbTimeout " +
                                "must be RequiresNew or NotSupported",
                                new Object[] {descriptor.getName()}));

                    }
                } else if(version.compareTo(SpecVersionMapper.JavaEEVersion_5)<0) {
                    // Transaction attribute for ejbTimeout not specified in the DD
                    addErrorDetails(result, compName);
                    result.failed(smh.getLocalString
                            (getClass().getName()+".failed3",
                            "Transaction attribute for Timeout is not specified for [ {0} ]",
                            new Object[] {descriptor.getName()}));
                }
            }
        }

        if (result.getStatus() != Result.FAILED) {
            addGoodDetails(result, compName);
            result.passed(smh.getLocalString
                    (getClass().getName()+".passed",
                    "Transaction attributes are properly specified"));

        }
        return result;
    }
}
