/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.verifier.tests.web;

import java.util.ArrayList;
import java.util.List;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.TagLibDescriptor;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.web.TagDescriptor;


/**
 * The name of tag must be unique.
 * @author Sudipto Ghosh
 */

public class TagNameIsUnique extends WebTest implements WebCheck {
    boolean oneFailed=false;

    public Result check(WebBundleDescriptor descriptor) {
        ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();
        Context context = getVerifierContext();
        Result result = loadWarFile(descriptor);

        TagLibDescriptor tlds[] = context.getTagLibDescriptors();
        if (tlds == null) {
            addGoodDetails(result, compName);
            result.passed(smh.getLocalString
                    (getClass().getName() + ".passed",
                            "No tag lib files are specified"));
            return result;
        }
        for(TagLibDescriptor tld : tlds) {
            TagDescriptor[] tagDesc = tld.getTagDescriptors();
            List<String> name = new ArrayList<String>();
            for(TagDescriptor td : tagDesc) {
                name.add(td.getTagName());
            }
            if (name != null) {
                String[] names = (String[])name.toArray(new String[0]);
                if (!checkForDuplicateNames(result, compName, names, tld)) {
                    addGoodDetails(result, compName);
                    result.addGoodDetails(smh.getLocalString
                            (getClass().getName() + ".passed1",
                                    "All 'name' elements are defined properly under tag element of [ {0} ]",
                                    new Object[]{tld.getUri()}));
                }
            }
        }
        if(oneFailed){
            result.setStatus(Result.FAILED);
        } else {
            result.setStatus(Result.PASSED);
        }
        return result;
    }

    public boolean checkForDuplicateNames(Result result, ComponentNameConstructor compName, String[] names, TagLibDescriptor tld) {
        boolean duplicate = false;
        for(int i=0; i<names.length-1;i++){
            for (int j=i+1; j<names.length; j++) {
                duplicate = names[i].trim().equals(names[j]);
                if(duplicate) {
                    oneFailed=true;
                    addErrorDetails(result, compName);
                    result.addErrorDetails(smh.getLocalString
                            (getClass().getName() + ".failed",
                                    "The name element value [ {0} ] under tag " +
                            "element in [ {1} ] is not unique",
                                    new Object[] {names[i], tld.getUri()}));
                }
            }
        }
        return oneFailed;
    }
}
