/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.verifier.tests.web.runtime;


import com.sun.enterprise.deployment.*;
import com.sun.enterprise.tools.verifier.*;
import com.sun.enterprise.tools.verifier.tests.*;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.tests.web.*;
import com.sun.enterprise.deployment.runtime.common.*;

//<addition author="irfan@sun.com" [bug/rfe]-id="4711198" >
/* Changed the result messages to reflect consistency between the result messages generated 
 * for the EJB test cases for SunONE specific deployment descriptors*/
//</addition>


public class ASResourceRefName extends WebTest implements WebCheck {

    public Result check(WebBundleDescriptor descriptor) {
        String resrefName;
        Result result = getInitializedResult();
        ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();
//Start Bugid:4703107
        DefaultResourcePrincipal defPrincipal;
//End Bugid:4703107
        boolean oneFailed = false;
        boolean notApp = false;
        try{
            ResourceRef[] resRefs = (descriptor.getSunDescriptor()).getResourceRef();
            if (resRefs != null && resRefs.length > 0) {
                for (int rep=0; rep<resRefs.length; rep++ ) {
                    resrefName = resRefs[rep].getResRefName();
                    if (validResRefName(resrefName,descriptor)) {
                        addGoodDetails(result, compName);
                        result.passed(smh.getLocalString
                                (getClass().getName() + ".passed",
                                        "PASSED [AS-WEB sun-web-app] resource-ref name [ {0} ] properly defined in the war file.",
                                        new Object[] {resrefName}));

                    }
                    else {
                        oneFailed = true;
                        addErrorDetails(result, compName);
                        result.failed(smh.getLocalString
                                (getClass().getName() + ".failed",
                                        "FAILED [AS-WEB sun-web-app] resource-ref name [ {0} ] is not valid, either empty or not defined in web.xml.",
                                        new Object[] {resrefName}));
                    }
                    //Start Bugid:4703107
                    defPrincipal = resRefs[rep].getDefaultResourcePrincipal();
                    if(defPrincipal != null){
                        boolean defResourcePrincipalValid = true;
                        String defaultname = defPrincipal.getName();
                        String defaultpassword = defPrincipal.getPassword();
                        if((defaultname == null)||(defaultname.length() == 0)){
                            oneFailed=true;
                            defResourcePrincipalValid = false;
                            addErrorDetails(result, compName);
                            result.failed(smh.getLocalString
                                    (getClass().getName() + ".failed2",
                                            "FAILED [AS-WEB resource-ref] name field in DefaultResourcePrincipal of ResourceRef [ {0} ] is not specified or is an empty string.",
                                            new Object[] {resrefName}));
                        }
                        if((defaultpassword == null)||(defaultpassword.length() == 0)){
                            oneFailed=true;
                            defResourcePrincipalValid = false;
                            addErrorDetails(result, compName);
                            result.failed(smh.getLocalString
                                    (getClass().getName() + ".failed3",
                                            "FAILED [AS-WEB resource-ref] password field in DefaultResourcePrincipal of ResourceRef [ {0} ] is not specified or is an empty string.",
                                            new Object[] {resrefName}));
                        }
                        if(defResourcePrincipalValid){
                            addGoodDetails(result, compName);
                            result.passed(smh.getLocalString
                                    (getClass().getName() + ".passed3",
                                            "PASSED [AS-WEB resource-ref]  DefaultResourcePrincipal of ResourceRef [ {0} ] properly defined",
                                            new Object[] {resrefName}));
                        }
                    }
                    //End Bugid:4703107
                }
            } else {
                notApp = true;
                addNaDetails(result, compName);
                result.notApplicable(smh.getLocalString
                        (getClass().getName() + ".notApplicable",
                                "NOT APPLICABLE [AS-WEB sun-web-app] resource-ref element not defined in the web archive [ {0} ].",
                                new Object[] {descriptor.getName()}));
            }
            if (oneFailed) {
                result.setStatus(Result.FAILED);
            } else if(notApp) {
                result.setStatus(Result.NOT_APPLICABLE);
            }else {
                result.setStatus(Result.PASSED);
                addGoodDetails(result, compName);
                result.passed
                        (smh.getLocalString
                        (getClass().getName() + ".passed2",
                                "PASSED [AS-WEB sun-web-app] resource-ref element(s) are valid within the web archive [ {0} ] .",
                                new Object[] {descriptor.getName()} ));
            }
        }catch(Exception ex){
            oneFailed=true;
            addErrorDetails(result, compName);
            result.failed(smh.getLocalString
                    (getClass().getName() + ".failed4", "FAILED [AS-WEB resource-env-ref] Could not create the resource-ref"));

        }
        return result;
    }

    boolean validResRefName(String name,WebBundleDescriptor descriptor){
        boolean valid =true;
        if(name !=null && name.length()!=0) {
            try{
                descriptor.getResourceReferenceByName(name);
            }
            catch(IllegalArgumentException e){
                valid=false;
            }
        }  else{
            valid=false;

        }

        return valid;
    }
}
