/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.web.spec22;

import com.sun.enterprise.tools.verifier.tests.web.WebTest;
import java.util.zip.*;
import java.util.jar.*;
import java.util.*;
import java.io.*;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.deployment.*;
import com.sun.enterprise.tools.verifier.*;
import com.sun.enterprise.tools.verifier.tests.*;
import com.sun.enterprise.util.FileClassLoader;


/** 
 * Jsp file element contains the full path to Jsp file within web application
 * test.
 */
public class JspFileName extends WebTest implements WebCheck { 

    
    /**
     * Jsp file in Servlet 2.2 applications must start with a leading  /
     * 
     * @param descriptor the Web deployment descriptor
     *   
     * @return <code>Result</code> the results for this assertion
     */
    public Result check(WebBundleDescriptor descriptor) {

	Result result = getInitializedResult();
	ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();
    String specVersion = descriptor.getSpecVersion();
    Float specVer = new Float(specVersion);
	if (!descriptor.getJspDescriptors().isEmpty()) {
	    boolean oneFailed = false;
        int count = getNonRuntimeCountNodeSet("/web-app/servlet");
        for(int i=1;i<=count;i++){
            String jspFilename = getXPathValueForNonRuntime("/web-app/servlet["+i+"]/jsp-file");
            if(jspFilename!=null){
                if (jspFilename.startsWith("/")){
                    if(specVer.compareTo(new Float("2.3"))<0){
                        result.addGoodDetails(smh.getLocalString
                                ("tests.componentNameConstructor",
                                        "For [ {0} ]",
                                        new Object[] {compName.toString()}));
                        result.addGoodDetails(smh.getLocalString(getClass().getName() + ".passed",
                                " PASSED : Jsp Name [ {0} ] is valid",
                                new Object[] { jspFilename }));

                    }else{
                        result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor",
                                "For [ {0} ]",
                                new Object[] {compName.toString()}));
                        result.addGoodDetails(smh.getLocalString(getClass().getName() + ".passed1",
                                " Jsp Name [ {0} ] is valid and starts with a leading '/'",
                                new Object[] { jspFilename }));

                    }
                }else{
                    if(specVer.compareTo(new Float("2.3"))<0){
                        result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor",
                                "For [ {0} ]",
                                new Object[] {compName.toString()}));
                        result.addGoodDetails(smh.getLocalString(getClass().getName() + ".passed",
                                " PASSED Jsp Name [ {0} ] is valid",
                                new Object[] { jspFilename }));

                    }else{
                        result.addErrorDetails(smh.getLocalString
                                ("tests.componentNameConstructor",
                                        "For [ {0} ]",
                                        new Object[] {compName.toString()}));
                        result.addErrorDetails(smh.getLocalString(getClass().getName() + ".failed",
                                " Error : Jsp Name [ {0} ] in invalid as it does not start with a leading '/'",
                                new Object[] { jspFilename }));
                        oneFailed=true;
                    }
                }

            }
        }
        if (oneFailed) {
            result.setStatus(Result.FAILED);
        } else {
            result.setStatus(Result.PASSED);
        }
    } else {
        result.addNaDetails(smh.getLocalString
                ("tests.componentNameConstructor",
                        "For [ {0} ]",
                        new Object[] {compName.toString()}));
        result.notApplicable(smh.getLocalString
                (getClass().getName() + ".notApplicable",
                        "There are no Jsp components within the web archive [ {0} ]",
                        new Object[] {descriptor.getName()}));
    }
        return result;

    }
}
