/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.webservices;

import com.sun.enterprise.deployment.*;
import com.sun.enterprise.tools.verifier.*;
import java.util.*;
import com.sun.enterprise.tools.verifier.tests.*;
import java.lang.reflect.*;

/* 
 *   @class.setup_props: ; 
 */ 

/*  
 *   @testName: check  
 *   @assertion_ids:  JSR109_WS_19; JSR109_WS_23; 
 *   @test_Strategy: 
 *   @class.testArgs: Additional arguments (if any) to be passed when execing the client  
 *   @testDescription: Service Implementations using a stateless session bean must be defined 
 *   in the ejb-jar.xml deployment descriptor file using the session element.
 *
 *   For a stateless session bean implementation, the ejb-link element 
 *   associates the port-component with a session element in the ejb-jar.xml. The ejb-link 
 *   element may not refer to a session element defined in another module.
 */

public class EJBEndpointIsSLSBCheck extends WSTest implements WSCheck {

    /**
     * @param descriptor the WebServices  descriptor
     * @return <code>Result</code> the results for this assertion
     */
    public Result check (WebServiceEndpoint wsdescriptor) {

	Result result = getInitializedResult();
        ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();

        if (wsdescriptor.implementedByEjbComponent()) {
            EjbDescriptor ejbdesc = wsdescriptor.getEjbComponentImpl();

            if (ejbdesc == null) {

               result.addErrorDetails(smh.getLocalString
                                  ("tests.componentNameConstructor",
                                   "For [ {0} ]",
                                   new Object[] {compName.toString()}));
                 result.failed(smh.getLocalString
                   (getClass().getName() + ".failed1",
                    "Service Implementation bean Could Not be Resolved from the ejb-link specified"));
               return result;
             }

            if (ejbdesc instanceof EjbSessionDescriptor) {
               EjbSessionDescriptor session = (EjbSessionDescriptor)ejbdesc;
               if (EjbSessionDescriptor.STATELESS.equals(session.getSessionType())) {
                   result.addGoodDetails(smh.getLocalString
                                  ("tests.componentNameConstructor",
                                   "For [ {0} ]",
                                   new Object[] {compName.toString()}));
                   result.passed(smh.getLocalString
                   (getClass().getName() + ".passed",
                   "Service Implementation bean defined in ejb-jar.xml using {0} session element",                   new Object[] {"stateless"}));
               }
               else {
                 // result.fail, endpoint can be a stateful session bean
                 result.addErrorDetails(smh.getLocalString
                                  ("tests.componentNameConstructor",
                                   "For [ {0} ]",
                                   new Object[] {compName.toString()}));
                 result.failed(smh.getLocalString
                   (getClass().getName() + ".failed",
                    "Service Implementation bean cannot be Stateful Session Bean"));
               }
            }
            else {
              // result.fail, service endpoint should be Session Bean
              result.addErrorDetails(smh.getLocalString
                     ("tests.componentNameConstructor", "For [ {0} ]",
                      new Object[] {compName.toString()}));
              result.failed(smh.getLocalString
                 (getClass().getName() + ".failed2",
                 "Service Implementation bean Should be a Session Bean"));
            }
  
        }
        else {

          // result.notapp
          result.addNaDetails(smh.getLocalString
                     ("tests.componentNameConstructor", "For [ {0} ]",
                      new Object[] {compName.toString()}));
          result.notApplicable(smh.getLocalString
                 (getClass().getName() + ".notapp",
                 "This is a JAX-RPC Service Endpoint"));
        }

        return result;
    }
 }

