/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.verifier.webservices;

import javax.enterprise.deploy.shared.ModuleType;
import java.util.Iterator;

import com.sun.enterprise.deployment.*;
import com.sun.enterprise.tools.verifier.CheckMgr;
import com.sun.enterprise.tools.verifier.FrameworkContext;
import com.sun.enterprise.tools.verifier.JarCheck;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;

/**
 * WebServices harness
 */
public class WebServiceCheckMgrImpl extends CheckMgr implements JarCheck {

    /**
     * name of the file containing the list of tests for the webservice
     * architecture
     */
    private final String testsListFileName = "TestNamesWebServices.xml"; // NOI18N
    private final String sunONETestsListFileName = getSunPrefix().concat(
            testsListFileName);
    private String moduleName;

    public WebServiceCheckMgrImpl(FrameworkContext frameworkContext) {
        this.frameworkContext = frameworkContext;
    }

    /**
     * Check Ejb for spec. conformance
     *
     * @param descriptor WebServices descriptor
     */
    public void check(Descriptor descriptor) throws Exception {
        WebServicesDescriptor rootDescriptor = (WebServicesDescriptor) descriptor;
        ModuleType moduleType = rootDescriptor.getBundleDescriptor()
                .getModuleType();
        if (moduleType == ModuleType.EJB)
            moduleName = Result.EJB;
        else if (moduleType == ModuleType.WAR)
            moduleName = Result.WEB;
        for (Iterator itr = rootDescriptor.getWebServices().iterator();
             itr.hasNext();) {
            WebService wsDescriptor = (WebService) itr.next();  
            // need to pass WebServiceEndpoint's to check
            for (Iterator endPtItr = wsDescriptor.getEndpoints().iterator();
                 endPtItr.hasNext();) {
                super.check((WebServiceEndpoint) endPtItr.next());
            }
        }
    }

    /**
     * return the configuration file name for the list of tests pertinent to the
     * connector architecture
     *
     * @return <code>String</code> filename containing the list of tests
     */
    protected String getTestsListFileName() {
        return testsListFileName;
    }

    /**
     * @return <code>String</code> filename containing sunone tests
     */
    protected String getSunONETestsListFileName() {
        return sunONETestsListFileName;
    }

    protected String getSchemaVersion(Descriptor descriptor) {
        return ((WebServiceEndpoint) descriptor).getWebService().
                getWebServicesDescriptor().getSpecVersion();
    }

    protected void setModuleName(Result r) {
        r.setModuleName(moduleName);
    }
    
    protected BundleDescriptor getBundleDescriptor(Descriptor descriptor) {
        return ((WebServiceEndpoint) descriptor).getBundleDescriptor();
    }

    protected ComponentNameConstructor getComponentNameConstructor(
            Descriptor descriptor) {
        return new ComponentNameConstructor((WebServiceEndpoint)descriptor);
    }

}
