/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.jdo.api.persistence.enhancer.util;

import java.util.ResourceBundle;

import com.sun.jdo.spi.persistence.utility.I18NHelper;


/**
 * Basic support for enhancer implementation.
 */
//@olsen: added class
public class Support
    extends Assertion {

    //^olsen: hack
    static public final Timer timer = new Timer();

    /**
     * I18N message handler
     */
    static private ResourceBundle MESSAGES;


    /**
     *
     */
    static
    {
        try
        {
            MESSAGES = I18NHelper.loadBundle(
                "com.sun.jdo.api.persistence.enhancer.Bundle", //NOI18N
                Support.class.getClassLoader());
        }
        catch (java.util.MissingResourceException ex)
        {
            ex.printStackTrace ();
        }
    }

    /**
     * Returns the I18N message.
     */
    static protected final String getI18N(String key) {
        return I18NHelper.getMessage(MESSAGES, key);
    }

    /**
     * Returns the I18N message.
     */
    static protected final String getI18N(String key,
                                          String arg) {
        return I18NHelper.getMessage(MESSAGES, key, arg);
    }

    /**
     * Returns the I18N message.
     */
    static protected final String getI18N(String key,
                                          String arg1,
                                          String arg2) {
        return I18NHelper.getMessage(MESSAGES, key, arg1, arg2);
    }

    /**
     * Returns the I18N message.
     */
    static protected final String getI18N(String key,
                                          String arg1,
                                          String arg2,
                                          String arg3) {
        return I18NHelper.getMessage(MESSAGES, key, arg1, arg2, arg3);
    }

    /**
     * Returns the I18N message.
     */
    static protected final String getI18N(String key,
                                          int arg1,
                                          String arg2) {
        return I18NHelper.getMessage(MESSAGES, key,
                                     new Object[]{new Integer(arg1), arg2});
    }

    /**
     * Returns the I18N message.
     */
    static protected final String getI18N(String key,
                                          Object[] args) {
        return I18NHelper.getMessage(MESSAGES, key, args);
    }
}
