/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.appserv.ha.spi;

/**
 * A class that saves a set of EjbMetaData atomically. The implementation is
 * responsible for atomically saving all the <code>BatchMetadata</code> that
 * is passed as parameter to the <code>saveAll()</code> method.
 */
public interface BatchBackingStore {

    /**
     * Save all the BatchMetadata atomically.
     * <p>
     * Note that not all <code>BatchMetadata.getAppId()</code> in the
     * collection may return the same value. The store is expected to save all
     * of them atomically
     * 
     * @param data
     *            the BatchMetadata to be stored
     * @throws BackingStoreException
     * @throws BackingStoreException
     *             if the underlying store implementation encounters any
     *             exception
     */
    public void saveAll(BatchMetadata... data) throws BackingStoreException;

}
