/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.appserv.ha.spi;

/**
 * A class for storing meta information
 */
public class SimpleMetadata extends Metadata {

    private byte[] state;

    private String extraParam;

    /**
     * Construct a Metadata object
     * 
     * @param version
     *            The version of the data. A freshly created state has a version ==
     *            0
     * @param lastAccessTime
     *            the last access time of the state. This must be used in
     *            conjunction with getMaxInactiveInterval to determine if the
     *            state is idle enough to be removed.
     * @param maxInactiveInterval
     *            the maximum time that this state can be idle in the store
     *            before it can be removed.
     * @param state
     *            The state
     * @param extraParam
     *            Some more data
     */
    public SimpleMetadata(long version, long lastAccessTime,
            long maxInactiveInterval, byte[] state, String extraParam) {
        super(version, lastAccessTime, maxInactiveInterval);
        this.state = state;
        this.extraParam = extraParam;
    }

    /**
     * Get the state of the object that is stored.
     * 
     * @return the state or null
     */
    public byte[] getState() {
        return state;
    }

    /**
     * Get the extra param associated with this metadata
     * 
     * @return the extra param or null
     */
    public String getExtraParam() {
        return extraParam;
    }

}
