/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/** SampleResultSetScenario.java
**/

package sample;

import javax.naming.*;
import javax.resource.cci.*;
import java.util.Iterator;
import java.sql.SQLException;
import javax.resource.ResourceException;

public class SampleResultSetScenario {

  public void method() {
    
    try {
      Context nc = new InitialContext();

      // JNDI lookup for ConnectionFactory
      ConnectionFactory cf = (ConnectionFactory)nc.lookup(
				 "java:comp/env/eis/ConnectionFactory");
      Connection cx = cf.getConnection();

      // Create an Interaction. 
      Interaction ix = cx.createInteraction();

      // Create an InteractionSpec and set properties.
      InteractionSpecImpl ixSpec = new InteractionSpecImpl();
      ixSpec.setFunctionName("<NAME OF FUNCTION>");
      ixSpec.setInteractionVerb(InteractionSpec.SYNC_SEND_RECEIVE);

      RecordFactory rf = cf.getRecordFactory();
      
      // Create an input MappedRecord. The component code adds values
      // based on the meta information it has accessed from the metadata
      // repository. The name of the Record acts as a pointer to the 
      // meta information (stored in the metadata repository) for a 
      // specific record type.
      MappedRecord input = rf.createMappedRecord("Name of Record");
      input.put("<key: element1>", new String("<VALUE1>"));
      input.put("<key: element2>", new String("<VALUE2>")); 

      // Execute the Interaction
      ResultSet rs = (javax.resource.cci.ResultSet)ix.execute(ixSpec, input);

      // Iterate over the ResultSet. The example here positions the
      // cursor on the first row and then iterates forward through 
      // the contents of the ResultSet. The getXXX methods are used
      // to retrieve column values:      
      rs.beforeFirst();
      while (rs.next()) {
	// Look at the current row of the resultSet
      }
    }
    catch (NamingException ne) {
      return;
    }
    catch (ResourceException e) {
      return;
    }    
    catch (SQLException e) {
      return;
    }    
  }



  public static void main(String[] args) {
  }

}
