/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.security.jauth;

/**
 * ConfigFile relies on a ConfigParser to read
 * the module configuration.
 *
 * <p> The ConfigParser is expected to parse that information
 * into the HashMap described below.
 *
 * @version %I%, %G%
 */
interface ConfigParser {

    /**
     * Get the module configuration information.
     * The information is returned as a HashMap.
     *
     * <p> The key is an intercept:
     * <ul>
     * <li>SOAP
     * <li>HTTP
     * <li>EJB
     * </ul>
     *
     * <p>The value is a ConfigFile.InterceptEntry, which contains:
     * <ul>
     * <li> default provider ID
     * <li> default type (client or server)
     * <li> HashMap, where
     *		key	= provider ID
     *		value	= ConfigFile.IDEntry
     * </ul>
     *
     * <p> An IDEntry contains:
     * <ul>
     * <li> type (client or server)
     * <li> default requestPolicy
     * <li> default responsePolicy
     * <li> ArrayList javax.security.auth.login.AppConfigurationEntry (modules)
     * </ul>
     */
    java.util.HashMap getConfigMap();
}
