/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package javax.enterprise.deploy.spi.status;

import java.io.Serializable;
import javax.enterprise.deploy.spi.exceptions.ClientExecuteException;

/**
 * The ClientConfiguration object configures an Application
 * Client for execution by a deployment tool.  This class 
 * should resolve the settings for installing and running
 * the application client.
 */
/**
 * The ClientConfiguration object installs, configures and
 * executes an Application Client. This class resolves the 
 * settings for installing and running the application client.
 */
public interface ClientConfiguration extends Serializable
{
	/**
     * This method performs an exec and starts the 
     * application client running in another process.
     *
     * @throws ClientExecuteException when the configuration
     *         is incomplete.
     */
	public void execute() throws ClientExecuteException;
}
