/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2007, Oracle. All rights reserved.  
package oracle.toplink.essentials.exceptions.i18n;

import java.util.ListResourceBundle;

/**
 * INTERNAL:
 * English ResourceBundle for DatabaseException messages.
 *
 * Creation date: (12/6/00 9:47:38 AM)
 * @author: Xi Chen
 */
public class DatabaseExceptionResource extends ListResourceBundle {
    static final Object[][] contents = {
                                           { "4003", "Configuration error.  Class [{0}] not found." },
                                           { "4005", "DatabaseAccessor not connected." },
                                           { "4006", "Error reading BLOB data from stream in getObject()." },
                                           { "4007", "Could not convert object type due to an internal error. {0}java.sql.TYPES: [{1}]" },
                                           { "4008", "You cannot logout while a transaction is in progress." },
                                           { "4009", "The sequence table information is not complete." },
                                           { "4011", "Error preallocating sequence numbers.  The sequence table information is not complete." },
                                           { "4014", "Cannot register SynchronizationListener." },
                                           { "4015", "Synchronized UnitOfWork does not support the commitAndResume() operation." },
                                           { "4016", "Configuration error.  Could not instantiate driver [{0}]." },
                                           { "4017", "Configuration error.  Could not access driver [{0}]." },
                                           { "4018", "The TransactionManager has not been set for the JTS driver." },
                                           { "4019", "Error while obtaining information about the database. Please look at the nested exception for more details." }
    };

    /**
     * Return the lookup table.
     */
    protected Object[][] getContents() {
        return contents;
    }
}
