/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2007, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.ejb.cmp3;

import java.lang.instrument.*;
import java.lang.reflect.Field;
import java.lang.reflect.Method;


/**
 * This agent is intended to be run prior to start up on a CMP3 JavaSE application.
 * It gets the globalInstrumentation and makes it available to TopLink's initialization code.
 * There are two kinds of initialization.  Normally, initialization occurs through reflective
 * creation and invokation of TopLink JavaSECMPInitializer.
 * It is possible to run it with the "main" argument to the agent in which case it will simply
 * try to set the globalInstrumentation field on the JavaSECMPInitializer.  This type of initialization
 * is useful when debugging, but imposes some restrictions on the user.  One such restriction is
 * that no domain classes that use lazy loading may be references in any way other than reflective in the application
 */
public class JavaSECMPInitializerAgent {
    public static void premain(String agentArgs, Instrumentation instr) throws Exception {
        // Reflection allows:
        //  JavaSECMPInitializerAgent to be the *ONLY* class is the jar file specified in -javaagent;
        //  Loading JavaSECMPInitializer class using SystemClassLoader.
        if ((agentArgs != null) && agentArgs.equals("main")) {
            initializeFromMain(instr);
        } else {
            initializeFromAgent(instr);
        }
    }
    
    public static void initializeFromAgent(Instrumentation instr) throws Exception {
            Class cls = Class.forName("oracle.toplink.essentials.internal.ejb.cmp3.JavaSECMPInitializer");
            Method method = cls.getDeclaredMethod("initializeFromAgent", new Class[] { Instrumentation.class });
            method.invoke(null, new Object[] { instr });
    }
    
    public static void initializeFromMain(Instrumentation instr) throws Exception {
            Class cls = Class.forName("oracle.toplink.essentials.internal.ejb.cmp3.JavaSECMPInitializer");
            Field field = cls.getField("globalInstrumentation");
            field.set(null, instr);        
    }
}
