/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2007, Oracle. All rights reserved. 
package oracle.toplink.essentials.internal.ejb.cmp3.xml.parser;

import java.util.ArrayList;
import java.util.List;

import oracle.toplink.essentials.internal.helper.Helper;

public class XMLException extends RuntimeException {
    private List m_nestedExceptions;

    public XMLException() {
        super();
        m_nestedExceptions = new ArrayList(); 
    }
    
    public void addNestedException(Exception nestedException) {
        m_nestedExceptions.add(nestedException);
    }
    
    public String getMessage() {
        StringBuffer buffer = new StringBuffer();
        Exception nestedException;
        for (int x=0; x<m_nestedExceptions.size(); x++) {
            nestedException = (Exception) m_nestedExceptions.get(x);
            buffer.append(Helper.cr());
            buffer.append('(');
            buffer.append(x + 1);
            buffer.append(". ");
            buffer.append(nestedException.getMessage());
            buffer.append(')');
        }
        return buffer.toString();
    }
    
    public String toString() { return getMessage(); }
}
