/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2007, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.identitymaps;

import java.util.*;

/**
 * Used to allow iterating over a maps cache keys.
 */
public class IdentityMapKeyEnumeration implements Enumeration {
    protected FullIdentityMap map;
    protected Enumeration cacheKeysEnum;
    protected CacheKey nextKey;

    public IdentityMapKeyEnumeration(FullIdentityMap map) {
        this.map = map;
        this.cacheKeysEnum = map.getCacheKeys().elements();
    }

    public boolean hasMoreElements() {
        this.nextKey = getNextCacheKey();
        return this.nextKey != null;
    }

    public Object nextElement() {
        if (this.nextKey == null) {
            throw new NoSuchElementException("IdentityMapKeyEnumeration nextElement");
        }

        // CR#... Must check the read lock to avoid
        // returning half built objects.
        this.nextKey.checkReadLock();
        return this.nextKey;
    }

    protected CacheKey getNextCacheKey() {
        CacheKey key = null;
        while (cacheKeysEnum.hasMoreElements() && (key == null)) {
            key = (CacheKey)cacheKeysEnum.nextElement();
        }
        return key;
    }
}
