/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2007, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.parsing;

import oracle.toplink.essentials.expressions.*;

/**
 * INTERNAL
 * <p><b>Purpose</b>: This node represnts a Parameter (?1) in an EJBQL
 * <p><b>Responsibilities</b>:<ul>
 * <li> Generate the correct expression for an AND in EJBQL
 * <li> Maintain a
 * <li>
 * </ul>
 *    @author Jon Driscoll and Joel Lucuik
 *    @since TopLink 4.0
 */
public class ParameterNode extends Node {

    /** */
    private String name;

    /**
     * Return a new ParameterNode.
     */
    public ParameterNode() {
        super();
    }

    /**
     * INTERNAL
     * Create a new ParameterNode with the passed string.
     * @param newVariableName java.lang.String
     */
    public ParameterNode(String newParameterName) {
        setParameterName(newParameterName);
    }

    /**
     * INTERNAL 
     */
    public void validateParameter(ParseTreeContext context, Object contextType) {
        context.defineParameterType(name, contextType, getLine(), getColumn());
        setType(context.getParameterType(name));
    }

    /** */
    public Expression generateExpression(GenerationContext context) {
        //create builder, and add
        Class baseClass = context.getBaseQueryClass();
        ExpressionBuilder builder = new ExpressionBuilder(baseClass);
        Expression whereClause = builder.getParameter(getParameterName(), getType());
        return whereClause;
    }

    /**
     * INTERNAL
     * Return the parameterName
     *
     */
    public String getAsString() {
        return getParameterName();
    }

    /**
     * INTERNAL
     * Return the parameter name
     */
    public String getParameterName() {
        return name;
    }

    /** */
    public void setParameterName(String name) {
        this.name = name;
    }

    /**
     * INTERNAL
     * Yes this is a Parameter node
     */
    public boolean isParameterNode() {
        return true;
    }

}
