/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 2005, 2006, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.weaving;

// J2SE imports
import java.util.*;

/**
 * INTERNAL:
 * Internal helper class that holds details of a persistent class.
 * Used by {@link TopLinkWeaver}
 * 
 */

public class ClassDetails {

	// the name of this class (obviously!)
	protected String className;
	// superclass' name
	protected String superClassName;
	// superclass' ClassDetails - only populated if superclass
	// is also persistent
	protected ClassDetails superClassDetails;

	protected boolean weaveValueHolders = false;
	// map of this class' persistent attributes
	protected Map attributesMap; // Map<String, AttributeDetails>
                                 // where the key is the Attribute name
    protected Map getterMethodToAttributeDetails;
    
    protected Map setterMethodToAttributeDetails;
    
    protected List lazyOneToOneMappings;
    
    protected boolean isMappedSuperClass = false;
	
	// default constructor
	public ClassDetails() {
	}
	
	public String getClassName() {
		return className;
	}
	public void setClassName(String className) {
		this.className = className;
	}

	public String getSuperClassName() {
		return superClassName;
	}
	public void setSuperClassName(String superClassName) {
		this.superClassName = superClassName;
	}

	public ClassDetails getSuperClassDetails() {
		return superClassDetails;
	}
	public void setSuperClassDetails(ClassDetails superClassDetails) {
		this.superClassDetails = superClassDetails;
	}

	public boolean weavedValueHolders() {
		return weaveValueHolders;
	}
	public void weaveValueHolders(boolean weaveValueHolders) {
		this.weaveValueHolders = weaveValueHolders;
	}
	
	public Map getAttributesMap() {
		return attributesMap;
	}

    public Map getGetterMethodToAttributeDetails(){
        return getterMethodToAttributeDetails;
    }
    
    public List getLazyOneToOneMappings(){
        return lazyOneToOneMappings;
    }
    
    public Map getSetterMethodToAttributeDetails(){
        return setterMethodToAttributeDetails;
    }
    
	public void setAttributesMap(Map weavedVHAttributes) {
		this.attributesMap = weavedVHAttributes;
	}
    
    public void setGetterMethodToAttributeDetails(Map map){
        getterMethodToAttributeDetails = map;
    }
    
    public void setLazyOneToOneMappings(List lazyOneToOneMappings){
        this.lazyOneToOneMappings = lazyOneToOneMappings;
    }
    
    public boolean isMappedSuperClass(){
        return isMappedSuperClass;
    }
    
    public void setIsMappedSuperClass(boolean isMappedSuperClass){
        this.isMappedSuperClass = isMappedSuperClass;
    }
    
    public void setSetterMethodToAttributeDetails(Map map){
        setterMethodToAttributeDetails = map;
    }
	
    public AttributeDetails getAttributeDetailsFromClassOrSuperClass(String attributeName){
        AttributeDetails attribute = (AttributeDetails)attributesMap.get(attributeName);
        if (attribute == null && superClassDetails != null){
            return superClassDetails.getAttributeDetailsFromClassOrSuperClass(attributeName);
        }
       return attribute; 
    }
    
	public String toString() {
		StringBuffer sb = new StringBuffer(className);
		sb.append(" extends ");
		sb.append(superClassName);
		sb.append(" weaveVH: ");
		if (weavedValueHolders()) {
			sb.append("true");
		}
		else {
			sb.append("false");
		}
		return sb.toString();
	}
}
