/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package javax.security.jacc;

import java.lang.Exception;

/**
 * This checked exception is thrown by implementations of the 
 * <code>javax.security.jacc.PolicyConfiguration</code> Interface, the
 * <code>javax.security.jacc.PolicyConfigurationFactory</code> abstract class,
 * the <code>javax.security.jacc.PolicyContext</code> utility class, and 
 * implementations of the 
 * <code>javax.security.jacc.PolicyContextException</code> Interface.
 * <P>
 * This exception is used by javax.security.jacc implementation 
 * classes to rethrow checked exceptions ocurring within an
 * implementation that are not declared by the interface or class 
 * being implemented.
 *
 * @see java.lang.Exception
 * @see javax.security.jacc.PolicyConfiguration
 * @see javax.security.jacc.PolicyConfigurationFactory
 * @see javax.security.jacc.PolicyContext
 * @see javax.security.jacc.PolicyContextHandler
 *
 * @author Ron Monzillo
 * @author Gary Ellison
 */

public class PolicyContextException extends java.lang.Exception {

   /** 
    * Constructs a new PolicyContextException with 
    * <code>null</code> as its detail message.
    * describing the cause of the exception.
    */
    public PolicyContextException()
    {
        super();
    }

   /** 
    * Constructs a new PolicyContextException with the specified detail message
    * @param msg - a <code>String</code> containing a detail message 
    * describing the cause of the exception.
    */

    public PolicyContextException(String msg)
    {
        super(msg);
    }

   /** 
    * Constructs a new PolicyContextException with the specified detail message
    * and cause. The cause will be encapsulated in the constructed exception.
    * @param msg - a <code>String containing a detail message describing the 
    * cause of the exception.
    * @param cause - the Throwable that is "causing" this exception to be 
    * constructed. A null value is permitted, and the value passed through
    * this parameter may subsequently be retrieved by calling 
    * <code>getCause()</code> on the constructed exception.
    */

    public PolicyContextException(String msg, Throwable cause)
    {
        super(msg,cause);
    }

   /** 
    * Constructs a new PolicyContextException with the specified cause.
    * The cause will be encapsulated in the constructed exception.
    *
    * @param cause - the Throwable that is "causing" this exception to be 
    * constructed. A null value is permitted, and the value passed through
    * this parameter may subsequently be retrieved by calling 
    * <code>getCause()</code> on the constructed exception.
    */

    public PolicyContextException(Throwable cause)
    {
        super(cause);
    }
}





