/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.gjc.spi;

/**
 * ConnectionRequestInfo implementation for Generic JDBC Connector.
 *
 * @author Binod P.G
 * @version 1.0, 02/07/31
 */
public class ConnectionRequestInfo implements javax.resource.spi.ConnectionRequestInfo {

    private String user;
    private String password;

    /**
     * Constructs a new <code>ConnectionRequestInfo</code> object
     *
     * @param user     User Name.
     * @param password Password
     */
    public ConnectionRequestInfo(String user, String password) {
        this.user = user;
        this.password = password;
    }

    /**
     * Retrieves the user name of the ConnectionRequestInfo.
     *
     * @return User name of ConnectionRequestInfo.
     */
    public String getUser() {
        return user;
    }

    /**
     * Retrieves the password of the ConnectionRequestInfo.
     *
     * @return Password of ConnectionRequestInfo.
     */
    public String getPassword() {
        return password;
    }

    /**
     * Verify whether two ConnectionRequestInfos are equal.
     *
     * @return True, if they are equal and false otherwise.
     */
    public boolean equals(Object obj) {
        if (obj == null) return false;
        if (obj instanceof ConnectionRequestInfo) {
            ConnectionRequestInfo other = (ConnectionRequestInfo) obj;
            return (isEqual(this.user, other.user) &&
                    isEqual(this.password, other.password));
        } else {
            return false;
        }
    }

    /**
     * Retrieves the hashcode of the object.
     *
     * @return hashCode.
     */
    public int hashCode() {
        String result = "" + user + password;
        return result.hashCode();
    }

    /**
     * Compares two objects.
     *
     * @param o1 First object.
     * @param o2 Second object.
     */
    private boolean isEqual(Object o1, Object o2) {
        if (o1 == null) {
            return (o2 == null);
        } else {
            return o1.equals(o2);
        }
    }

}