/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.gjc.spi;


import javax.resource.ResourceException;
import javax.resource.spi.LocalTransactionException;

/**
 * <code>LocalTransaction</code> implementation for Generic JDBC Connector.
 *
 * @author Evani Sai Surya Kiran
 * @version 1.0, 02/08/03
 */
public class LocalTransaction implements javax.resource.spi.LocalTransaction {

    private ManagedConnection mc;

    /**
     * Constructor for <code>LocalTransaction</code>.
     *
     * @param mc <code>ManagedConnection</code> that returns
     *           this <code>LocalTransaction</code> object as
     *           a result of <code>getLocalTransaction</code>
     */
    public LocalTransaction(ManagedConnection mc) {
        this.mc = mc;
    }

    /**
     * Begin a local transaction.
     *
     * @throws LocalTransactionException if there is an error in changing
     *                                   the autocommit mode of the physical
     *                                   connection
     */
    public void begin() throws ResourceException {
        //GJCINT
        mc.transactionStarted();
        try {
            mc.getActualConnection().setAutoCommit(false);
        } catch (java.sql.SQLException sqle) {
            throw new LocalTransactionException(sqle.getMessage());
        }
    }

    /**
     * Commit a local transaction.
     *
     * @throws LocalTransactionException if there is an error in changing
     *                                   the autocommit mode of the physical
     *                                   connection or committing the transaction
     */
    public void commit() throws ResourceException {
        try {
            mc.getActualConnection().commit();
            mc.getActualConnection().setAutoCommit(true);
        } catch (java.sql.SQLException sqle) {
            throw new LocalTransactionException(sqle.getMessage());
        }
        //GJCINT
        mc.transactionCompleted();
    }

    /**
     * Rollback a local transaction.
     *
     * @throws LocalTransactionException if there is an error in changing
     *                                   the autocommit mode of the physical
     *                                   connection or rolling back the transaction
     */
    public void rollback() throws ResourceException {
        try {
            mc.getActualConnection().rollback();
            mc.getActualConnection().setAutoCommit(true);
        } catch (java.sql.SQLException sqle) {
            throw new LocalTransactionException(sqle.getMessage());
        }
        //GJCINT
        mc.transactionCompleted();
    }

}
