package com.sun.gjc.spi.jdbc30;

import com.sun.gjc.spi.JdbcObjectsFactory;
import com.sun.gjc.spi.base.ConnectionHolder;

import java.sql.Connection;

/**
 * Factory to create jdbc30 connection & datasource
 */
public class Jdbc30ObjectsFactory extends JdbcObjectsFactory {

    /**
     * To get an instance of ConnectionHolder30.<br>
     * Will return a ConnectionHolder30 with or without wrapper<br>
     *
     * @param conObject Connection
     * @param mcObject   ManagedConnection
     * @param criObject  ConnectionRequestInfo
     * @param statementWrapping Whether to wrap statement objects or not.
     * @return ConnectionHolder
     */
    public ConnectionHolder getConnection(Connection conObject,
                                          com.sun.gjc.spi.ManagedConnection mcObject,
                                          javax.resource.spi.ConnectionRequestInfo criObject,
                                          boolean statementWrapping) {
        ConnectionHolder connection = null;

        if (statementWrapping) {
            connection = new ConnectionWrapper30(conObject, mcObject, criObject);
        } else {
            connection = new ConnectionHolder30(conObject, mcObject, criObject);
        }
        return connection;
    }

    /**
     * Returns a DataSource instance for JDBC 3.0
     * @param mcfObject Managed Connection Factory
     * @param cmObject  Connection Manager
     * @return DataSource
     */
    public javax.sql.DataSource getDataSourceInstance(com.sun.gjc.spi.ManagedConnectionFactory mcfObject,
                                                      javax.resource.spi.ConnectionManager cmObject) {
        return new DataSource30(mcfObject, cmObject);
    }
}
