package com.sun.gjc.spi.jdbc40;

import com.sun.gjc.spi.JdbcObjectsFactory;
import com.sun.gjc.spi.base.ConnectionHolder;

import java.sql.Connection;
import java.lang.reflect.Method;
import java.lang.reflect.InvocationTargetException;

/**
 * Factory to create jdbc40 connection & datasource
 */
public class Jdbc40ObjectsFactory extends JdbcObjectsFactory {
    //indicates whether JDBC 3.0 Connection (and hence JDBC 3.0 DataSource) is used
    private boolean jdbc30Connection;
    //indicates whether detection of JDBC 3.0 Datasource in JDK 1.6 is done or not
    private boolean initJDBC30Connection;

    /**
     * To get an instance of ConnectionHolder40.<br>
     * Will return a ConnectionHolder40 with or without wrapper<br>
     *
     * @param conObject Connection
     * @param mcObject  ManagedConnection
     * @param criObject Connection Request Info
     * @param statementWrapping Whether to wrap statement objects or not. 
     * @return ConnectionHolder
     */
    public ConnectionHolder getConnection(Connection conObject,
                                          com.sun.gjc.spi.ManagedConnection mcObject,
                                          javax.resource.spi.ConnectionRequestInfo criObject,
                                          boolean statementWrapping) {
        ConnectionHolder connection = null;
        if(!initJDBC30Connection){
            detectJDBC30Connection(conObject);
        }
        if (statementWrapping) {
            connection = new ConnectionWrapper40(conObject, mcObject, criObject, jdbc30Connection);
        } else {
            connection = new ConnectionHolder40(conObject, mcObject, criObject, jdbc30Connection);
        }
        return connection;
    }

    /**
     * Returns a DataSource instance for JDBC 4.0
     * @param mcfObject Managed Connection Factory
     * @param cmObject  Connection Manager
     * @return DataSource
     */
    public javax.sql.DataSource getDataSourceInstance(com.sun.gjc.spi.ManagedConnectionFactory mcfObject,
                                                      javax.resource.spi.ConnectionManager cmObject) {
        return new DataSource40(mcfObject, cmObject);
    }

     public boolean isJdbc30Connection() {
        return jdbc30Connection;
    }

    public void setJdbc30Connection(boolean jdbc30Connection) {
        this.jdbc30Connection = jdbc30Connection;
    }

    public boolean isJDBC30ConnectionDetected(){
        return initJDBC30Connection;
    }

    public void detectJDBC30Connection(Connection con) {
        try {
            Class paramClasses[] = new Class[]{Class.class};
            Method isWrapperMethod = con.getClass().getMethod("isWrapperFor",paramClasses);
            isWrapperMethod.invoke(con, java.sql.Connection.class);
        } catch (NoSuchMethodException e) {
            setJdbc30Connection(true);
        }catch(AbstractMethodError e){
            setJdbc30Connection(true);
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        } catch (InvocationTargetException ite) {
            ite.printStackTrace();
        }
        initJDBC30Connection = true;
    }
}
