/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package javax.security.auth.message.config;

import javax.security.auth.message.*;

// just for @see tag
import javax.security.auth.message.module.ClientAuthModule;

/**
 * This ClientAuthContext class encapsulates ClientAuthModules that are used
 * to secure service requests made by a client, and to validate any responses
 * received to those requests. A caller typically uses this class
 * in the following manner:
 *
 * <ol>
 * <li> Retrieve an instance of this class via
 *	ClientAuthConfig.getAuthContext.
 * <li> Invoke <i>secureRequest</i>.
 *	<br>
 *	ClientAuthContext implementation invokes secureRequest of encapsulated
 *	ClientAuthModule(s).  Module(s) attach credentials to initial
 *	request object (for example, a username and password),
 *	and/or secure the request (for example, sign and encrypt the request).
 * <li> Send request and receive response.
 * <li> Invoke <i>validateResponse</i>.
 *	<br>
 *	ClientAuthContext implementation invokes validateResponse of 
 *      encapsulated
 *	ClientAuthModule(s). Module(s) verify or decrypt response as necessary.
 * <li> Invoke <i>cleanSubject</i> method (as necessary)
 *	to clean up any authentication state in Subject.
 * </ol>
 * 
 * <p> A ClientAuthContext instance may be used concurrently by multiple
 * callers.
 *
 * <p> Implementations of this interface are responsible for constructing
 * and initializing the encapsulated modules.  The initialization step
 * includes passing the relevant request and response MessagePolicy objects
 * to the encapsulated modules.  The MessagePolicy objects are obtained
 * by the ClientAuthConfig instance used to obtain the ClientAuthContext 
 * object.
 * See <code>ClientAuthConfig.getAuthContext</code> for more information.
 *
 * <p> Implementations of this interface are instantiated by their associated
 * configuration object such that they know which modules to invoke, in what 
 * order, and how results returned by preceding modules are to influence 
 * subsequent module invocations.
 *
 * <p> Calls to the inherited methods of this interface delegate to the
 * corresponding methods of the encapsulated authentication modules.
 *
 * @version %I%, %G%
 * @see ClientAuthConfig
 * @see ClientAuthModule
 */
public interface ClientAuthContext extends ClientAuth {

}










