/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package javax.security.auth.message.config;

import javax.security.auth.message.*;

/**
 * An implementation of this interface may associated with an 
 * AuthConfigProvider registration at an AuthConfigFactory at the 
 * time the AuthConfigProvider is obtained for use from the factory. 
 * The AuthConfigFactory will invoke the notify
 * method of the RegistrationListener if the corresponding provider 
 * registration is unregistered or replaced at the factory. 
 */

public interface RegistrationListener {

    /**
     * notify the listener that a registration with which it was
     * associated, was replaced or unregistered.
     *
     * <p> when a RegistrationListener is associated with a provider
     * registration within the factory, the factory must call its
     * <code>notify</code> method when the corresponding registration 
     * is unregistered or replaced.
     
     * @param layer a String identifying the message layer(s) 
     * corresponding to registration for which the listerner is being 
     * notified.
     *
     * @param appContext a String value identifying the application 
     * context(s) corresponding to registration for which the listerner is 
     * being notified.
     *
     * The factory detaches the listener from the corresponding 
     * registration once the listener has been notified for the 
     * registration.
     * 
     * The <code>detachListerner</code> method
     * must be called to detach listeners that are no longer in use.
     */
    public void notify(String layer, String appContext);
    
}




















