/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package javax.security.auth.message.config;

import javax.security.auth.message.*;

// just for @see tag
import javax.security.auth.message.module.ServerAuthModule;

/**
 * This ServerAuthContext class encapsulates ServerAuthModules that are used
 * to validate service requests received from clients, and to secure any 
 * response returned for those requests.  A caller typically uses this class
 * in the following manner:
 *
 * <ol>
 * <li> Retrieve an instance of this class via
 *      ServerAuthConfig.getAuthContext.
 * <li> Invoke <i>validateRequest</i>.
 *      <br>
 *	ServerAuthContext implementation invokes validateRequest on 
 *      encapsulated
 *	ServerAuthModule(s).  Module(s) validate credentials present in request
 *	(for example, decrypt and verify a signature).
 *	If credentials valid and sufficient, 
 * <li> Authentication complete.
 *      <br>
 *      Perform authorization check on authenticated identity and,
 *	if successful, dispatch to requested service application.
 * <li> Service application finished.
 * <li> Invoke <i>secureResponse</i>.
 *      <br>
 *	ServerAuthContext implementation invokes secureResponse on encapsulated
 *	ServerAuthModule(s).  Module(s) secure response
 *	(sign and encrypt response, for example), and prepare response message.
 * <li> Send secured response to client.
 * <li> Invoke <i>cleanSubject</i> (as necessary)
 *	to clean up any authentication state in Subject(s).
 * </ol>
 *
 * <p> A ServerAuthContext instance may be used concurrently by multiple
 * callers.
 *
 * <p> Implementations of this interface are responsible for constructing
 * and initializing the encapsulated modules.  The initialization step
 * includes passing the relevant request and response MessagePolicy objects
 * to the encapsulated modules. The MessagePolicy objects are obtained
 * by the ServerAuthConfig instance used to ontain the ServerAuthContext 
 * object.
 * See <code>ServerAuthConfig.getAuthContext</code> for more information.
 *
 * <p> Implementations of this interface are instantiated by their associated
 * configuration object such that they know which modules to invoke, in what 
 * order, and how results returned by preceding modules are to influence 
 * subsequent module invocations.
 *
 * <p> Calls to the inherited methods of this interface delegate to the
 * corresponding methods of the encapsulated authentication modules.
 *
 * @version %I%, %G%
 * @see ServerAuthConfig
 * @see ServerAuthModule
 */
public interface ServerAuthContext extends ServerAuth {

}








