/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.security.jmac;

import java.util.Map;

import javax.security.auth.message.MessageInfo;

import javax.xml.soap.SOAPMessage;

import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.message.Packet;

import com.sun.enterprise.security.jauth.SOAPAuthParam;

/**
 * 
 */
public class PacketMapMessageInfo implements PacketMessageInfo {

    private SOAPAuthParam soapAuthParam;

    private Map infoMap;

    public PacketMapMessageInfo(Packet reqPacket, Packet resPacket) {
	soapAuthParam = new SOAPAuthParam(reqPacket,resPacket,0);
    }

    public Map getMap() {
	if (this.infoMap == null) {
	    this.infoMap = soapAuthParam.getMap();
	}
	return this.infoMap;
    }

    public Object getRequestMessage() {
	return soapAuthParam.getRequest();
    }

    public Object getResponseMessage() {
	return soapAuthParam.getResponse();
    }

    public void setRequestMessage(Object request) {
	soapAuthParam.setRequest((SOAPMessage)request);
    }

    public void setResponseMessage(Object response) {
	soapAuthParam.setResponse((SOAPMessage)response);
    }

    public SOAPAuthParam getSOAPAuthParam() {
	return soapAuthParam;
    }

    public Packet getRequestPacket() {
	return (Packet) soapAuthParam.getRequestPacket();
    }

    public Packet getResponsePacket() {
	return (Packet) soapAuthParam.getResponsePacket();
    }

    public void setRequestPacket(Packet p) {
	soapAuthParam.setRequestPacket(p);
    }

    public void setResponsePacket(Packet p) {
	soapAuthParam.setResponsePacket(p);
    }
}











