/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package javax.management.j2ee.statistics;

/**
 * Specifies the statistics provided by a JCA connection
 */
public interface JCAConnectionStats extends Stats {
    /** 
     * Returns the associated JCAConnectionFactory OBJECT_NAME
     * @return String the OBJECT_NAME of the managed object that identifies
     * the connection factory for this connection
     */
    String getConnectionFactory();

    /**
     * Returns the associated JCAManagedConnectionFactory OBJECT_NAME
     * @return String the OBJECT_NAME of the managed object that identifies
     * the managed connection factory for this connection
     */
    String getManagedConnectionFactory();

    /**
     * Returns the time spent waiting for a connection to be available
     * @return TimeStatistic
     */
    TimeStatistic getWaitTime();

    /**
     * Returns the time spent using a connection
     * @return TimeStatistic
     */
    TimeStatistic getUseTime();
}
