/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.common.dd;

import org.netbeans.modules.schema2beans.BaseBean;
import org.netbeans.modules.schema2beans.GraphManager;
import org.netbeans.modules.schema2beans.BaseProperty;
/** Utilities that apply to all the various generated schema2beans objects in the
 * system
 * @author vkraemer
 */
public class BaseBeanUtils {
    
    /** Creates a new instance of BaseBeanUtils */
    protected BaseBeanUtils() {
    }
    
    /** A utility for finding beans in a graph of BaseBean objects.
     *
     * Search the bean graph, starting at a given root, for beans where the named
     * property has the given value.  The returned list is filtered by assignment
     * compatibility.
     * @return The assignment compatible BaseBeans that were found.
     * @param root The root of a search
     * @param propName The name of the element
     * @param propVal the value of the element
     * @param type The expected type of the value to be returned.
     * @throws IllegalArgumentException If the bean is not part of a complete bean graph.
     */    
    protected static java.util.List findCompatibleBeansWithValue(BaseBean root, String propName, String propVal, Class type) throws IllegalArgumentException {
        java.util.List retVal = null; 
        GraphManager gm = root.graphManager();
        if (null == gm) 
            throw new IllegalArgumentException("Disconnected beans not supported");
        String[] props = root.findPropertyValue(propName, propVal);
        int len = 0;
        if (null != props)
            len = props.length;
        if (len > 0)
            retVal = new java.util.ArrayList(); 
        for (int i = 0; i < len; i++) {
            // get the bean that is the property's parent.
            BaseBean candidate = gm.getPropertyParent(props[i]); 
            if (type.isInstance(candidate))
                retVal.add(candidate);
        }
        return retVal;
    }
}
