/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * ClusterInfo.java
 *
 * Created on May 21, 2004, 3:03 PM
 */

package com.sun.enterprise.tools.upgrade.cluster;

/**
 *
 * @author  prakash
 */

/*
 * This class represents one clinstance.conf file. 
 */

import java.util.*;
import java.io.*;
import com.sun.enterprise.tools.upgrade.common.UpgradeUtils;

public class ClusterInfo {
    
    // This cluster name is not really extracted from clinstance.conf.  This will be the name that is used to create cluster in 8.0.
    // This is useful in handling rest of cluster processing code.
    private String clusterName;
    private List clusteredInstanceList;
    // This domain nameis added for AS8.x to AS9.0 upgrade
    private String domainName;
    private static java.util.logging.Logger log = com.sun.enterprise.tools.upgrade.common.CommonInfoModel.getDefaultLogger();

    public ClusterInfo(){
    }
    public List getClusteredInstanceList(){
        return this.clusteredInstanceList;
    }
    public void parseClinstanceConfFile(File file) throws FileNotFoundException, IOException{
        if(clusteredInstanceList == null){
            clusteredInstanceList = new ArrayList();
        }
        clusteredInstanceList.clear();
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        String line = null;
        ClusteredInstance clInstance = null;            
        while((line = reader.readLine()) != null){
            if(line.trim().startsWith("#")){
                // Comment line.  pass on
                continue;
            }
            if(line.trim().startsWith("instancename")){
                String instanceName = line.substring("instancename".length()).trim();
                clInstance = createNewInstance(instanceName);
                continue;
            } 
            if(clInstance != null)
                clInstance.extractDataFromLine(line);
        }
    }

    //Added for CR 6480041
    /**
      * Method to build the ClusteredInstance list with domain name
      * and respective cluster name.
      */	  
    public void updateClusteredInstanceList(String domainXMLFile, 
            String domainName, String clName, UpgradeUtils upgradeUtils) {
        if(clusteredInstanceList == null) {
            clusteredInstanceList = new ArrayList();
        }
        clusteredInstanceList.clear();		
        upgradeUtils.updateClusteredInstanceList(domainXMLFile,
            domainName, clName, clusteredInstanceList);
    }
    //End - added

    private ClusteredInstance createNewInstance(String instanceName){
        ClusteredInstance clInstance = new ClusteredInstance(instanceName);
        clusteredInstanceList.add(clInstance);
        return clInstance;
    }
    public ClusteredInstance getMasterInstance(){
        ClusteredInstance clInstance = null; 
        for(Iterator it = this.clusteredInstanceList.iterator(); it.hasNext();){
            clInstance = (ClusteredInstance)it.next();
            if(clInstance.isMaster())
                return clInstance;
        }
        return null;
    }
    public String getDomainName(){
        if(this.domainName == null){
            ClusteredInstance clInstance = this.getMasterInstance();
            if((clInstance == null) && (this.clusteredInstanceList.size() > 0)){
                clInstance = (ClusteredInstance)this.clusteredInstanceList.get(0);
            }
            this.domainName = clInstance.getDomain();
            return clInstance.getDomain();
        }
        return this.domainName;
    }
    public void setDomainName(String dName){
        this.domainName = dName;
    }
    public String getClusterName(){
        return this.clusterName;
    }
    public void setClusterName(String clName){
        this.clusterName = clName;
    }
    public void print(){
        if(clusteredInstanceList != null){
            for(Iterator it = clusteredInstanceList.iterator(); it.hasNext();){
                ClusteredInstance clInst = (ClusteredInstance)it.next();
                log.info(clInst.getInstanceName());
                log.info(clInst.getUser());
                log.info(clInst.getHost());
                log.info(clInst.getPort());
                log.info(clInst.getDomain());
                log.info(clInst.getInstancePort());
                log.info(String.valueOf(clInst.isMaster()));
                log.info("\n");
            }
        }
    }    
}
