/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * WssServerConfigXMLTransfer.java
 *
 */

package com.sun.enterprise.tools.upgrade.miscconfig;

/**
 *
 */
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;

import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

import java.io.File;
import java.io.IOException;

import org.w3c.dom.Document;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

// For transformation.  Not really needed to retain.
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerConfigurationException;

import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import java.io.*;
import java.util.logging.*;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.tools.upgrade.logging.*;

public class WssServerConfigXMLTransfer {

    private StringManager stringManager = StringManager.
            getManager("com.sun.enterprise.tools.upgrade.miscconfig");
    private Logger logger = com.sun.enterprise.tools.upgrade.common.CommonInfoModel.
            getDefaultLogger();

    /** Creates a new instance of WssServerConfigXMLTransfer */
    public WssServerConfigXMLTransfer() {}

    public void transform(String targetFileName){
        logger.log(Level.INFO, stringManager.
            getString("upgrade.configTransfers.wssServerConfig.startMessage"));
        File targetFile = new File(targetFileName);
        this.modifyContent(targetFile);
    }

    private void modifyContent(File xmlFile){
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver((org.xml.sax.helpers.DefaultHandler)Class.forName
                ("com.sun.enterprise.config.serverbeans.ServerValidationHandler").newInstance());
            Document document = builder.parse( xmlFile );
            Element docEle = document.getDocumentElement();
            // Need to obtain the element named xwss:Encrypt
            NodeList encryptElements = docEle.getElementsByTagName("xwss:Encrypt");
            for(int lh =0; lh < encryptElements.getLength(); lh++){
                Element encryptElement = ((Element)encryptElements.item(lh));
                String encryptAttr = encryptElement.getAttribute("keyEncryptionAlgorithm");
                if(encryptAttr != null) {
                    if(encryptAttr.equals("RSA_v1dot5")) {
                        //Remove this attribute
                        encryptElement.removeAttribute("keyEncryptionAlgorithm");
                    }
                }
            }
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(new FileOutputStream(xmlFile));
            transformer.transform(source, result);

        }catch (Exception ex){
            // Log error
            logger.log(Level.SEVERE, stringManager.
                    getString("upgrade.configTransfers.wssServerConfig.startFailureMessage",ex.getMessage()), ex);
        }
    }
}
