/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * TransformManager.java
 *
 * Created on August 4, 2003, 12:47 PM
 */

package com.sun.enterprise.tools.upgrade.transform;

import com.sun.enterprise.tools.upgrade.transform.elements.*;
import java.io.File;
import java.io.IOException;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;

import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

import org.w3c.dom.Document;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

// For transformation.  Not really needed to retain.
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerConfigurationException;

import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.OutputKeys;

import java.io.*;
import com.sun.enterprise.tools.upgrade.common.*;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.tools.upgrade.logging.*;
import java.util.logging.*;
import java.util.Vector;
import java.util.Enumeration;


/**
 *
 * @author  prakash
 */
public class TransformManager implements BaseModule{
    
    private static TransformManager transManager;
    private Document sourceDocument;
    private Document resultDocument;
    private StringManager stringManager = StringManager.getManager("com.sun.enterprise.tools.upgrade.transform");
    private Logger logger = CommonInfoModel.getDefaultLogger();
    private Vector recoveryList = new Vector();
    
    /** Creates a new instance of TransformManager */
    public TransformManager() {
    }
    public static TransformManager getTransformManager(){
        if(transManager == null)
            transManager = new TransformManager();
        return transManager;
    }
    
    public void transform(Document source, Document result){
        this.sourceDocument = source;
        this.resultDocument = result;
        try{
            Element docEle = sourceDocument.getDocumentElement();
            BaseElement baseElement = ElementToObjectMapper.getMapper().getElementObject(docEle.getTagName());
            baseElement.transform(docEle, source.getDocumentElement(), result.getDocumentElement());
        }catch(Exception ex){
            // ****** LOG MESSAGE *************
            logger.log(Level.SEVERE, stringManager.getString("upgrade.transform.startFailureMessage",ex.getMessage()),ex);
        }
    }
    public boolean upgrade(CommonInfoModel commonInfo) {
        logger.log(Level.INFO, stringManager.getString("upgrade.transform.startMessage"));
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        //factory.setValidating(false);
        
        factory.setNamespaceAware(true);
        if(commonInfo.getSourceDomainRootFlag()) {
            factory.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd",Boolean.FALSE);
        }
        
        try {
            backup(commonInfo.getTargetConfigXMLFile(), commonInfo);
            DocumentBuilder builder = factory.newDocumentBuilder();
            DocumentBuilder builderDomainXml = factory.newDocumentBuilder();
            builderDomainXml.setEntityResolver((org.xml.sax.helpers.DefaultHandler)Class.forName
                    ("com.sun.enterprise.config.serverbeans.ServerValidationHandler").newInstance());
            BaseElement.setCommonInfoModel(commonInfo);
            Document resultDoc = builderDomainXml.parse( new File(commonInfo.getTargetConfigXMLFile()) );
            // for testing only
            if(commonInfo.getSourceVersionAndEdition().equals(UpgradeConstants.VERSION_AS7X_SE) ||
                    commonInfo.getSourceVersionAndEdition().equals(UpgradeConstants.VERSION_AS7X_EE)){
                Document sourceDoc = builder.parse( new File(commonInfo.getSourceConfigXMLFile()));
                this.transform(sourceDoc, resultDoc);
                
            }else{
                if(!commonInfo.getSourceVersion().equals(UpgradeConstants.VERSION_7X)){
                    builder.setEntityResolver((org.xml.sax.helpers.DefaultHandler)Class.forName
                            ("com.sun.enterprise.config.serverbeans.ServerValidationHandler").newInstance());
                }
                Document sourceDoc = builder.parse( new File(commonInfo.getSourceConfigXMLFile()));
                if((sourceDoc.getDocumentElement() != null) && (resultDoc.getDocumentElement() != null))
                    this.transform(sourceDoc, resultDoc);
                else
                    return false;
            }
            
            // write out the resultDoc to destination file.
            
            // Use a Transformer for output
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            //transformer.setOutputProperty(OutputKeys.METHOD,"xml");
            //transformer.setOutputProperty(OutputKeys.INDENT,"no");
            
            if (resultDoc.getDoctype() != null){
                String systemValue = resultDoc.getDoctype().getSystemId();
                if(UpgradeConstants.VERSION_91.equals(commonInfo.getTargetVersion())) {
                    systemValue = "http://www.sun.com/software/appserver/dtds/sun-domain_1_3.dtd";
		} else if(UpgradeConstants.VERSION_90.equals(commonInfo.getTargetVersion())) {
                    systemValue = "http://www.sun.com/software/appserver/dtds/sun-domain_1_2.dtd";
                }		    
                transformer.setOutputProperty(OutputKeys.DOCTYPE_SYSTEM, systemValue);
                String pubValue = resultDoc.getDoctype().getPublicId();
                transformer.setOutputProperty(OutputKeys.DOCTYPE_PUBLIC, pubValue);
            }
            
            DOMSource source = new DOMSource(resultDoc);
            StreamResult result = new StreamResult(new FileOutputStream(commonInfo.getTargetConfigXMLFile()));
            transformer.transform(source, result);
            result.getOutputStream().close();
            
        }catch (Exception ex){
            UpdateProgressManager.getProgressManager().setContinueUpgrade(false);
            logger.log(Level.SEVERE, stringManager.getString("upgrade.transform.startFailureMessage",ex.getMessage()),ex);
            logger.log(Level.SEVERE, stringManager.getString("upgrade.transform.startFailureCheckAccessMessage"));
            //ex.printStackTrace();
            return false;
        }
        return true;
    }
    
    private void backup(String filePath, CommonInfoModel commonInfo) throws IOException {
        String backupFilePath = filePath + ".bak";
        UpgradeUtils.getUpgradeUtils(commonInfo).copyFile(filePath, backupFilePath);
        recoveryList.add(filePath);
    }
    
    public void recovery(CommonInfoModel commonInfo) {
        Enumeration e = recoveryList.elements();
        while(e.hasMoreElements()){
            String recoverPath = (String)e.nextElement();
            String backupPath = recoverPath + ".bak";
            try {
                UpgradeUtils.getUpgradeUtils(commonInfo).copyFile(backupPath, recoverPath);
                new File(backupPath).delete();
            } catch (IOException ioe) {
                logger.log(Level.SEVERE, stringManager.getString("upgrade.realm.recoveryFailureMessage",ioe.getMessage()),new Object[]{recoverPath,ioe});
            }
        }
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        System.setProperty("com.sun.aas.installRoot", "C:\\Softwares\\Sun\\j2eesdk1.4_beta3");
        DocumentBuilderFactory factory =
                DocumentBuilderFactory.newInstance();
        //factory.setValidating(true);
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document sourceDoc = builder.parse( new File("C:\\temp\\server.xml") );
            Document resultDoc = builder.parse( new File("C:\\temp\\domain.xml") );
            TransformManager transMan = TransformManager.getTransformManager();
            transMan.transform(sourceDoc, resultDoc);
            
            // write out the resultDoc to destination file.
            
            // Use a Transformer for output
            TransformerFactory tFactory =
                    TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            
            DOMSource source = new DOMSource(resultDoc);
            StreamResult result = new StreamResult(new FileOutputStream("c:\\temp\\domainModified.xml"));
            transformer.transform(source, result);
            result.getOutputStream().close();
            
        } catch (SAXParseException spe) {
            spe.printStackTrace();
        } catch (SAXException sxe) {
            sxe.printStackTrace();
            
        } catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        } catch (IOException ioe) {
            ioe.printStackTrace();
        } catch (Exception ex){
            ex.printStackTrace();
        }
    }
    
    public String getName() {
        return stringManager.getString("upgrade.transform.moduleName");
    }
    
}
