/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * AccessLog.java
 *
 */

package com.sun.enterprise.tools.upgrade.transform.elements;

/**
 *
 * @author  Hans Hrasna
 */
import java.text.SimpleDateFormat;
import java.util.logging.Level;
import org.w3c.dom.Element;


public class AccessLog extends GenericElement {

    /** Creates a new instance of ApplicationRef */
    public AccessLog() {
    }
    /**
     * element - application-ref
     * parentSource - server or cluster
     * parentResult - server or cluster
     */
    public void transform(Element element, Element parentSource, Element parentResult){
            super.transform(element,parentSource,parentResult);
            String rotationSuffix = element.getAttribute("rotation-suffix");
            logger.log(Level.FINE, stringManager.getString("upgrade.transform.accesslog.rotationSuffix"), rotationSuffix);
            if(rotationSuffix.equals("%YYYY;%MM;%DD;-%hh;h%mm;m%ss;s")) {
                return;
            }
            try {
                new SimpleDateFormat(rotationSuffix);
            }catch(IllegalArgumentException iae) {
                logger.log(Level.WARNING, stringManager.getString("upgrade.transfrorm.incompatible.rotation-suffix.format",rotationSuffix));
            }catch(NullPointerException npe) {
                logger.log(Level.WARNING, stringManager.getString("upgrade.transfrorm.incompatible.rotation-suffix.format",npe.getMessage()));
            }
    }

}
