/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Domain.java
 *
 * Created on March 17, 2004, 3:27 PM
 */

package com.sun.enterprise.tools.upgrade.transform.elements;

/**
 *
 * @author  prakash
 */
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Node;
import org.w3c.dom.Attr;
import java.util.logging.*;

public class Domain extends BaseElement  {
    
    //start CR 6426419
    private String DEFAULT_APPLICATION_ROOT = "${com.sun.aas.instanceRoot}/applications";
    //end CR 6426419

    /** Creates a new instance of Domain */
    public Domain() {
    }
    /**
     * element - Domain of source
     * parentSource - Domain of source
     * parentResult - domain of target
     */
    public void transform(Element element, Element parentSource, Element parentResult){
        this.transferAttributes(element, parentResult, this.getNonTransferList(element));
        super.transform(element,  parentSource, parentResult);  
    }
    protected java.util.List getNonTransferList(Element element){
        java.util.Vector attrList = new java.util.Vector();

        //start CR 6426419
        //if(commonInfoModel.checkUpgradefrom8xpeto8xse() ||
          if(commonInfoModel.checkUpgrade8xto9x() || commonInfoModel.checkUpgrade9xto9x()) {
            String sourceApplRoot = (String)element.getAttribute("application-root");
            commonInfoModel.setSourceApplicationRoot(sourceApplRoot);
            if(!(sourceApplRoot.equals(DEFAULT_APPLICATION_ROOT))) {
                logger.log(Level.INFO, "New Application Root is " + sourceApplRoot);
            }
        } else {
            //7.x to 8.x scenario			    
            attrList.add("application-root");
        }
	//start CR 6396940
        //attrList.add("application-root");
	//end CR 6396940
        attrList.add("log-root");
        return attrList;
    }   
}
