/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Element.java
 *
 * Created on August 4, 2003, 2:04 PM
 */

package com.sun.enterprise.tools.upgrade.transform.elements;

/**
 *
 * @author  prakash
 */
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Node;
import com.sun.enterprise.tools.upgrade.transform.ElementToObjectMapper;

public class Resources extends BaseElement {
    
    /** Creates a new instance of Element */
    public Resources() {
    }
    /**
     * element - resources
     * parentSource - server element for source for as7.x.  domain for 8.x
     * parentResult - domain element of result for 8.1PE, Config element for SE/EE
     */
    public void transform(Element element, Element parentSource, Element parentResult){
    
        // There should only be one or zero resources element
        if(!parentResult.getTagName().equals("domain")){
            // This fix is required, otherwise it would create resources element under cofig element.
            parentResult = parentResult.getOwnerDocument().getDocumentElement();
        }
        NodeList resources = parentResult.getElementsByTagName("resources");
        Element resource = null;
        if(resources.getLength() == 0){
            resource = parentResult.getOwnerDocument().createElement("resources");
            this.appendElementToParent(parentResult,resource);  
        }else {
            resource = (Element)resources.item(0);           
        } 
        super.transform(element,  parentSource, resource);       
    }    
}
