/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.appserv.web.taglibs.cache;

/**
 * Class responsible for caching and expiring the execution result of a JSP
 * fragment.
 */
public class CacheEntry
{
    public static final int NO_TIMEOUT = -1;

    String content;
    volatile long expireTime; 

    /**
     * Constructs a CacheEntry using the response string to be
     * cached and the timeout after which the entry will expire
     */
    public CacheEntry(String response, int timeout) {
        content = response; 
        computeExpireTime(timeout);  
    }

    /**
     * set the real expire time
     * @param expireTime in milli seconds
     */
    public void setExpireTime(long expireTime) {
        this.expireTime = expireTime;
    }

    /**
     * Gets the cached content.
     *
     * @return The cached content
     */
    public String getContent() {
        return this.content;
    }

    /**
     * compute when this entry to be expired based on timeout relative to 
     * current time.
     * @param timeout in seconds
     */
    public void computeExpireTime(int timeout) {
        // timeout is relative to current time
        this.expireTime = (timeout == NO_TIMEOUT) ? timeout :
                          System.currentTimeMillis() + (timeout * 1000);
    }

    /**
     * is this response still valid?
     */
    public boolean isValid() {
        return (expireTime > System.currentTimeMillis() ||
                expireTime == NO_TIMEOUT);
    }

    /** 
     * clear the contents
     */
    public void clear() {
        content = null;
        expireTime = 0L;
    }
}
